/*
 * Decompiled with CFR 0.152.
 */
package coil.fetch;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.util.TypedValue;
import androidx.annotation.DrawableRes;
import coil.bitmappool.BitmapPool;
import coil.decode.DataSource;
import coil.decode.DrawableDecoderService;
import coil.decode.Options;
import coil.fetch.DrawableResult;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.fetch.SourceResult;
import coil.size.Size;
import coil.util.ContextsKt;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\r\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ3\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\r\u001a\u00020\u0002H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\r\u001a\u00020\u0002H\u0016J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u0016*\u00020\u00052\b\b\u0001\u0010\u0018\u001a\u00020\u0002H\u0002J\u0016\u0010\u0019\u001a\u00020\u0014*\u00020\u001a2\b\b\u0001\u0010\u0018\u001a\u00020\u0002H\u0002J\u0016\u0010\u001b\u001a\u00020\u001c*\u00020\u001a2\b\b\u0001\u0010\u0018\u001a\u00020\u0002H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"Lcoil/fetch/ResourceFetcher;", "Lcoil/fetch/Fetcher;", "", "Landroidx/annotation/DrawableRes;", "context", "Landroid/content/Context;", "drawableDecoder", "Lcoil/decode/DrawableDecoderService;", "(Landroid/content/Context;Lcoil/decode/DrawableDecoderService;)V", "fetch", "Lcoil/fetch/FetchResult;", "pool", "Lcoil/bitmappool/BitmapPool;", "data", "size", "Lcoil/size/Size;", "options", "Lcoil/decode/Options;", "(Lcoil/bitmappool/BitmapPool;ILcoil/size/Size;Lcoil/decode/Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handles", "", "key", "", "getType", "resId", "isXmlResource", "Landroid/content/res/Resources;", "resIdToUri", "Landroid/net/Uri;", "coil-base_release"})
public final class ResourceFetcher
implements Fetcher<Integer> {
    private final Context context;
    private final DrawableDecoderService drawableDecoder;

    @Override
    public boolean handles(@DrawableRes int data) {
        boolean bl;
        try {
            bl = this.context.getResources().getResourceName(data) != null;
        }
        catch (Resources.NotFoundException e) {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public String key(@DrawableRes int data) {
        return "res_" + data;
    }

    @Override
    @SuppressLint(value={"ResourceType"})
    @Nullable
    public Object fetch(@NotNull BitmapPool pool, @DrawableRes int data, @NotNull Size size, @NotNull Options options, @NotNull Continuation<? super FetchResult> $completion) {
        FetchResult fetchResult;
        Resources resources = this.context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        if (this.isXmlResource(resources, data)) {
            fetchResult = new DrawableResult(this.drawableDecoder.convertIfNecessary(ContextsKt.getDrawableCompat(this.context, data), size, options.getConfig()), false, DataSource.MEMORY);
        } else {
            InputStream inputStream = this.context.getResources().openRawResource(data);
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"context.resources.openRawResource(data)");
            fetchResult = new SourceResult(Okio.buffer((Source)Okio.source((InputStream)inputStream)), this.getType(this.context, data), DataSource.MEMORY);
        }
        return fetchResult;
    }

    private final String getType(@NotNull Context $this$getType, @DrawableRes int resId) {
        ContentResolver contentResolver = $this$getType.getContentResolver();
        Resources resources = $this$getType.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return contentResolver.getType(this.resIdToUri(resources, resId));
    }

    private final Uri resIdToUri(@NotNull Resources $this$resIdToUri, @DrawableRes int resId) {
        Uri uri = new Uri.Builder().scheme("android.resource").authority($this$resIdToUri.getResourcePackageName(resId)).appendPath($this$resIdToUri.getResourceTypeName(resId)).appendPath($this$resIdToUri.getResourceEntryName(resId)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.Builder()\n          \u2026Id))\n            .build()");
        return uri;
    }

    private final boolean isXmlResource(@NotNull Resources $this$isXmlResource, @DrawableRes int resId) {
        CharSequence fileName;
        TypedValue typedValue = new TypedValue();
        boolean bl = false;
        boolean bl2 = false;
        TypedValue $this$apply = typedValue;
        boolean bl3 = false;
        $this$isXmlResource.getValue(resId, $this$apply, true);
        CharSequence charSequence = fileName = typedValue.string;
        return charSequence != null && StringsKt.endsWith$default((CharSequence)charSequence, (CharSequence)".xml", (boolean)false, (int)2, null);
    }

    public ResourceFetcher(@NotNull Context context, @NotNull DrawableDecoderService drawableDecoder) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)drawableDecoder, (String)"drawableDecoder");
        this.context = context;
        this.drawableDecoder = drawableDecoder;
    }
}

