/*
 * Decompiled with CFR 0.152.
 */
package coil.fetch;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArraySet;
import androidx.collection.ArraySetKt;
import androidx.core.net.UriKt;
import coil.bitmappool.BitmapPool;
import coil.decode.DataSource;
import coil.decode.Options;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.fetch.SourceResult;
import coil.size.Size;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0001\u00a2\u0006\u0002\b\tJ1\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lcoil/fetch/UriFetcher;", "Lcoil/fetch/Fetcher;", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "extractAssetFileName", "", "uri", "extractAssetFileName$coil_base_release", "fetch", "Lcoil/fetch/FetchResult;", "pool", "Lcoil/bitmappool/BitmapPool;", "data", "size", "Lcoil/size/Size;", "options", "Lcoil/decode/Options;", "(Lcoil/bitmappool/BitmapPool;Landroid/net/Uri;Lcoil/size/Size;Lcoil/decode/Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handles", "", "key", "Companion", "coil-base_release"})
public final class UriFetcher
implements Fetcher<Uri> {
    private final Context context;
    private static final String ASSET_FILE_PATH_SEGMENT = "android_asset";
    private static final ArraySet<String> SUPPORTED_SCHEMES;
    public static final Companion Companion;

    @Override
    public boolean handles(@NotNull Uri data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return SUPPORTED_SCHEMES.contains((Object)data.getScheme());
    }

    @Override
    @NotNull
    public String key(@NotNull Uri data) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (Intrinsics.areEqual((Object)data.getScheme(), (Object)"file")) {
            string = "" + data + ':' + UriKt.toFile((Uri)data).lastModified();
        } else {
            String string2 = data.toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.toString()");
        }
        return string;
    }

    @Override
    @Nullable
    public Object fetch(@NotNull BitmapPool pool, @NotNull Uri data, @NotNull Size size, @NotNull Options options, @NotNull Continuation<? super FetchResult> $completion) {
        InputStream inputStream;
        InputStream inputStream2;
        String assetFileName = this.extractAssetFileName$coil_base_release(data);
        if (assetFileName != null) {
            inputStream2 = this.context.getAssets().open(assetFileName);
        } else {
            InputStream inputStream3 = this.context.getContentResolver().openInputStream(data);
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (inputStream3 == null) {
                boolean bl4 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            inputStream2 = inputStream3;
        }
        InputStream inputStream4 = inputStream = inputStream2;
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream4, (String)"inputStream");
        return new SourceResult(Okio.buffer((Source)Okio.source((InputStream)inputStream4)), this.context.getContentResolver().getType(data), DataSource.DISK);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    @Nullable
    public final String extractAssetFileName$coil_base_release(@NotNull Uri uri) {
        List segments;
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file") ^ true) {
            return null;
        }
        List list = segments = uri.getPathSegments();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"segments");
        Object object = list;
        boolean bl = false;
        if (object.size() != 2) return null;
        if (!Intrinsics.areEqual((Object)((String)segments.get(0)), (Object)ASSET_FILE_PATH_SEGMENT)) return null;
        Object e = segments.get(1);
        Intrinsics.checkExpressionValueIsNotNull(e, (String)"segments[1]");
        object = (CharSequence)e;
        bl = false;
        if (StringsKt.isBlank((CharSequence)object)) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        String string = (String)segments.get(1);
        return string;
    }

    public UriFetcher(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    static {
        Companion = new Companion(null);
        SUPPORTED_SCHEMES = ArraySetKt.arraySetOf((Object[])new String[]{"android.resource", "content", "file"});
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcoil/fetch/UriFetcher$Companion;", "", "()V", "ASSET_FILE_PATH_SEGMENT", "", "SUPPORTED_SCHEMES", "Landroidx/collection/ArraySet;", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

