/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import android.graphics.Bitmap;
import android.util.Log;
import android.util.SparseIntArray;
import androidx.annotation.VisibleForTesting;
import coil.bitmappool.BitmapPool;
import coil.collection.SparseIntArraySet;
import coil.util.CoilLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\r\u0010\u0013\u001a\u00020\n*\u00020\fH\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcoil/memory/BitmapReferenceCounter;", "", "bitmapPool", "Lcoil/bitmappool/BitmapPool;", "(Lcoil/bitmappool/BitmapPool;)V", "counts", "Landroid/util/SparseIntArray;", "invalidKeys", "Lcoil/collection/SparseIntArraySet;", "count", "", "bitmap", "Landroid/graphics/Bitmap;", "decrement", "", "increment", "invalid", "", "invalidate", "key", "Companion", "coil-base_release"})
public final class BitmapReferenceCounter {
    private final SparseIntArray counts;
    private final SparseIntArraySet invalidKeys;
    private final BitmapPool bitmapPool;
    private static final String TAG = "BitmapReferenceCounter";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final void increment(@NotNull Bitmap bitmap) {
        String $receiver$iv;
        void $this$key$iv;
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Bitmap bitmap2 = bitmap;
        BitmapReferenceCounter this_$iv = this;
        boolean $i$f$key22 = false;
        int key = System.identityHashCode($this$key$iv);
        int count = this.counts.get(key);
        int newCount = count + 1;
        SparseIntArray $i$f$key22 = this.counts;
        int value$iv = newCount;
        $receiver$iv.put(key, value$iv);
        $receiver$iv = TAG;
        int priority$iv = 2;
        boolean $i$f$log = false;
        if (CoilLogger.INSTANCE.getEnabled$coil_base_release() && CoilLogger.INSTANCE.getLevel$coil_base_release() <= priority$iv) {
            void tag$iv;
            void var10_11 = tag$iv;
            int n = priority$iv;
            boolean bl = false;
            String string = "INCREMENT: [" + key + ", " + newCount + ']';
            Log.println((int)n, (String)var10_11, (String)string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void decrement(@NotNull Bitmap bitmap) {
        String $receiver$iv;
        void $this$key$iv;
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Bitmap bitmap2 = bitmap;
        BitmapReferenceCounter this_$iv = this;
        boolean $i$f$key22 = false;
        int key = System.identityHashCode($this$key$iv);
        int count = this.counts.get(key);
        int newCount = count - 1;
        SparseIntArray $i$f$key22 = this.counts;
        int value$iv = newCount;
        $receiver$iv.put(key, value$iv);
        $receiver$iv = TAG;
        int priority$iv = 2;
        boolean $i$f$log = false;
        if (CoilLogger.INSTANCE.getEnabled$coil_base_release() && CoilLogger.INSTANCE.getLevel$coil_base_release() <= priority$iv) {
            void tag$iv;
            void var10_12 = tag$iv;
            int n = priority$iv;
            boolean bl = false;
            String string = "DECREMENT: [" + key + ", " + newCount + ']';
            Log.println((int)n, (String)var10_12, (String)string);
        }
        if (newCount <= 0) {
            boolean isValid;
            this.counts.delete(key);
            boolean bl = isValid = !this.invalidKeys.remove(key);
            if (isValid) {
                this.bitmapPool.put(bitmap);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void invalidate(@NotNull Bitmap bitmap) {
        void $this$plusAssign$iv;
        void $this$key$iv;
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        SparseIntArraySet sparseIntArraySet = this.invalidKeys;
        Bitmap bitmap2 = bitmap;
        BitmapReferenceCounter this_$iv = this;
        boolean $i$f$key = false;
        int element$iv = System.identityHashCode($this$key$iv);
        boolean $i$f$plusAssign = false;
        $this$plusAssign$iv.add(element$iv);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final int count(@NotNull Bitmap bitmap) {
        void $this$key$iv;
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Bitmap bitmap2 = bitmap;
        BitmapReferenceCounter bitmapReferenceCounter = this;
        SparseIntArray sparseIntArray = this.counts;
        boolean $i$f$key = false;
        int n = System.identityHashCode($this$key$iv);
        return sparseIntArray.get(n);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final boolean invalid(@NotNull Bitmap bitmap) {
        void $this$key$iv;
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Bitmap bitmap2 = bitmap;
        BitmapReferenceCounter bitmapReferenceCounter = this;
        SparseIntArraySet sparseIntArraySet = this.invalidKeys;
        boolean $i$f$key = false;
        int n = System.identityHashCode($this$key$iv);
        return sparseIntArraySet.contains(n);
    }

    private final int key(@NotNull Bitmap $this$key) {
        int $i$f$key = 0;
        return System.identityHashCode($this$key);
    }

    public BitmapReferenceCounter(@NotNull BitmapPool bitmapPool) {
        Intrinsics.checkParameterIsNotNull((Object)bitmapPool, (String)"bitmapPool");
        this.bitmapPool = bitmapPool;
        this.counts = new SparseIntArray();
        this.invalidKeys = new SparseIntArraySet(0, 1, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/memory/BitmapReferenceCounter$Companion;", "", "()V", "TAG", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

