/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import android.graphics.Bitmap;
import android.util.Log;
import androidx.collection.LruCache;
import coil.memory.BitmapReferenceCounter;
import coil.memory.MemoryCache;
import coil.util.CoilLogger;
import coil.util.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000A\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006*\u0001\b\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bJ\u0013\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0002J\u0006\u0010\u0004\u001a\u00020\u0005J\u001e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0005R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcoil/memory/MemoryCache;", "", "referenceCounter", "Lcoil/memory/BitmapReferenceCounter;", "maxSize", "", "(Lcoil/memory/BitmapReferenceCounter;I)V", "cache", "coil/memory/MemoryCache$cache$1", "Lcoil/memory/MemoryCache$cache$1;", "clearMemory", "", "get", "Lcoil/memory/MemoryCache$Value;", "key", "", "set", "value", "Landroid/graphics/Bitmap;", "isSampled", "", "size", "trimMemory", "level", "Companion", "Value", "coil-base_release"})
public final class MemoryCache {
    private final cache.1 cache;
    private final BitmapReferenceCounter referenceCounter;
    private static final String TAG = "MemoryCache";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Value get(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return (Value)this.cache.get(key);
    }

    public final void set(@NotNull String key, @NotNull Bitmap value, boolean isSampled) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        int size = ExtensionsKt.getAllocationByteCountCompat(value);
        if (size > this.maxSize()) {
            this.cache.remove(key);
            return;
        }
        this.referenceCounter.increment(value);
        this.cache.put(key, new Value(value, isSampled, size));
    }

    public final int size() {
        return this.cache.size();
    }

    public final int maxSize() {
        return this.cache.maxSize();
    }

    /*
     * WARNING - void declaration
     */
    public final void clearMemory() {
        String string = TAG;
        int priority$iv = 3;
        boolean $i$f$log = false;
        if (CoilLogger.INSTANCE.getEnabled$coil_base_release() && CoilLogger.INSTANCE.getLevel$coil_base_release() <= priority$iv) {
            void tag$iv;
            void var6_4 = tag$iv;
            int n = priority$iv;
            boolean bl = false;
            String string2 = "clearMemory";
            Log.println((int)n, (String)var6_4, (String)string2);
        }
        this.cache.trimToSize(-1);
    }

    /*
     * WARNING - void declaration
     */
    public final void trimMemory(int level) {
        String string = TAG;
        int priority$iv = 3;
        boolean $i$f$log = false;
        if (CoilLogger.INSTANCE.getEnabled$coil_base_release() && CoilLogger.INSTANCE.getLevel$coil_base_release() <= priority$iv) {
            void tag$iv;
            void var7_6 = tag$iv;
            int n = priority$iv;
            boolean bl = false;
            String string2 = "trimMemory, level=" + level;
            Log.println((int)n, (String)var7_6, (String)string2);
        }
        if (level >= 40) {
            this.clearMemory();
        } else {
            int n = level;
            if (10 <= n && 20 > n) {
                this.cache.trimToSize(this.size() / 2);
            }
        }
    }

    public MemoryCache(@NotNull BitmapReferenceCounter referenceCounter, int maxSize) {
        Intrinsics.checkParameterIsNotNull((Object)referenceCounter, (String)"referenceCounter");
        this.referenceCounter = referenceCounter;
        this.cache = new LruCache<String, Value>(this, maxSize, maxSize){
            final /* synthetic */ MemoryCache this$0;
            final /* synthetic */ int $maxSize;

            protected void entryRemoved(boolean evicted, @NotNull String key, @NotNull Value oldValue, @Nullable Value newValue) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                Intrinsics.checkParameterIsNotNull((Object)oldValue, (String)"oldValue");
                MemoryCache.access$getReferenceCounter$p(this.this$0).decrement(oldValue.getBitmap());
            }

            protected int sizeOf(@NotNull String key, @NotNull Value value) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return value.getSize();
            }
            {
                this.this$0 = $outer;
                this.$maxSize = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
    }

    public static final /* synthetic */ BitmapReferenceCounter access$getReferenceCounter$p(MemoryCache $this) {
        return $this.referenceCounter;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcoil/memory/MemoryCache$Value;", "", "bitmap", "Landroid/graphics/Bitmap;", "isSampled", "", "size", "", "(Landroid/graphics/Bitmap;ZI)V", "getBitmap", "()Landroid/graphics/Bitmap;", "()Z", "getSize", "()I", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "coil-base_release"})
    public static final class Value {
        @NotNull
        private final Bitmap bitmap;
        private final boolean isSampled;
        private final int size;

        @NotNull
        public final Bitmap getBitmap() {
            return this.bitmap;
        }

        public final boolean isSampled() {
            return this.isSampled;
        }

        public final int getSize() {
            return this.size;
        }

        public Value(@NotNull Bitmap bitmap, boolean isSampled, int size) {
            Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
            this.bitmap = bitmap;
            this.isSampled = isSampled;
            this.size = size;
        }

        @NotNull
        public final Bitmap component1() {
            return this.bitmap;
        }

        public final boolean component2() {
            return this.isSampled;
        }

        public final int component3() {
            return this.size;
        }

        @NotNull
        public final Value copy(@NotNull Bitmap bitmap, boolean isSampled, int size) {
            Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
            return new Value(bitmap, isSampled, size);
        }

        public static /* synthetic */ Value copy$default(Value value, Bitmap bitmap, boolean bl, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bitmap = value.bitmap;
            }
            if ((n2 & 2) != 0) {
                bl = value.isSampled;
            }
            if ((n2 & 4) != 0) {
                n = value.size;
            }
            return value.copy(bitmap, bl, n);
        }

        @NotNull
        public String toString() {
            return "Value(bitmap=" + this.bitmap + ", isSampled=" + this.isSampled + ", size=" + this.size + ")";
        }

        public int hashCode() {
            Bitmap bitmap = this.bitmap;
            int n = (bitmap != null ? bitmap.hashCode() : 0) * 31;
            int n2 = this.isSampled ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return (n + n2) * 31 + Integer.hashCode(this.size);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Value)) break block3;
                    Value value = (Value)object;
                    if (!Intrinsics.areEqual((Object)this.bitmap, (Object)value.bitmap) || !(this.isSampled == value.isSampled) || !(this.size == value.size)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/memory/MemoryCache$Companion;", "", "()V", "TAG", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

