/*
 * Decompiled with CFR 0.152.
 */
package coil.transform;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.graphics.Shader;
import coil.bitmappool.BitmapPool;
import coil.transform.Transformation;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J!\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lcoil/transform/RoundedCornersTransformation;", "Lcoil/transform/Transformation;", "radius", "", "(F)V", "key", "", "transform", "Landroid/graphics/Bitmap;", "pool", "Lcoil/bitmappool/BitmapPool;", "input", "(Lcoil/bitmappool/BitmapPool;Landroid/graphics/Bitmap;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "coil-base_release"})
public final class RoundedCornersTransformation
implements Transformation {
    private final float radius;

    @Override
    @NotNull
    public String key() {
        return "" + RoundedCornersTransformation.class + '-' + this.radius;
    }

    @Override
    @Nullable
    public Object transform(@NotNull BitmapPool pool, @NotNull Bitmap input, @NotNull Continuation<? super Bitmap> $completion) {
        Canvas c$iv;
        Paint paint = new Paint(3);
        paint.setShader((Shader)new BitmapShader(input, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        int n = input.getWidth();
        int n2 = input.getHeight();
        Bitmap.Config config = input.getConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)"input.config");
        Bitmap output = pool.get(n, n2, config);
        RectF rect = new RectF(0.0f, 0.0f, (float)output.getWidth(), (float)output.getHeight());
        Bitmap $receiver$iv = output;
        Canvas $this$applyCanvas = c$iv = new Canvas($receiver$iv);
        boolean bl = false;
        $this$applyCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        $this$applyCanvas.drawRoundRect(rect, this.radius, this.radius, paint);
        pool.put(input);
        return output;
    }

    public RoundedCornersTransformation(float radius) {
        this.radius = radius;
        boolean bl = this.radius >= 0.0f;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Radius must be >= 0.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }
}

