/*
 * Decompiled with CFR 0.152.
 */
package coil.fetch;

import android.content.Context;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import coil.bitmap.BitmapPool;
import coil.decode.DataSource;
import coil.decode.Options;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.fetch.SourceResult;
import coil.size.Size;
import coil.util.-Extensions;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J1\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"Lcoil/fetch/AssetUriFetcher;", "Lcoil/fetch/Fetcher;", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "fetch", "Lcoil/fetch/FetchResult;", "pool", "Lcoil/bitmap/BitmapPool;", "data", "size", "Lcoil/size/Size;", "options", "Lcoil/decode/Options;", "(Lcoil/bitmap/BitmapPool;Landroid/net/Uri;Lcoil/size/Size;Lcoil/decode/Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handles", "", "key", "", "Companion", "coil-base_release"})
public final class AssetUriFetcher
implements Fetcher<Uri> {
    private final Context context;
    @NotNull
    public static final String ASSET_FILE_PATH_ROOT = "android_asset";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean handles(@NotNull Uri data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return Intrinsics.areEqual((Object)data.getScheme(), (Object)"file") && Intrinsics.areEqual((Object)-Extensions.getFirstPathSegment(data), (Object)ASSET_FILE_PATH_ROOT);
    }

    @Override
    @NotNull
    public String key(@NotNull Uri data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"data.toString()");
        return string;
    }

    @Override
    @Nullable
    public Object fetch(@NotNull BitmapPool pool, @NotNull Uri data, @NotNull Size size, @NotNull Options options, @NotNull Continuation<? super FetchResult> $completion) {
        List list = data.getPathSegments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"data.pathSegments");
        String path = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)list, (int)1), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        InputStream inputStream = this.context.getAssets().open(path);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.assets.open(path)");
        BufferedSource bufferedSource = Okio.buffer((Source)Okio.source((InputStream)inputStream));
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        Intrinsics.checkNotNullExpressionValue((Object)mimeTypeMap, (String)"MimeTypeMap.getSingleton()");
        return new SourceResult(bufferedSource, -Extensions.getMimeTypeFromUrl(mimeTypeMap, path), DataSource.DISK);
    }

    public AssetUriFetcher(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/fetch/AssetUriFetcher$Companion;", "", "()V", "ASSET_FILE_PATH_ROOT", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

