/*
 * Decompiled with CFR 0.152.
 */
package coil.fetch;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import androidx.annotation.VisibleForTesting;
import coil.bitmap.BitmapPool;
import coil.decode.DataSource;
import coil.decode.Options;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.fetch.SourceResult;
import coil.size.Size;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J1\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0002H\u0001\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lcoil/fetch/ContentUriFetcher;", "Lcoil/fetch/Fetcher;", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "fetch", "Lcoil/fetch/FetchResult;", "pool", "Lcoil/bitmap/BitmapPool;", "data", "size", "Lcoil/size/Size;", "options", "Lcoil/decode/Options;", "(Lcoil/bitmap/BitmapPool;Landroid/net/Uri;Lcoil/size/Size;Lcoil/decode/Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handles", "", "isContactPhotoUri", "isContactPhotoUri$coil_base_release", "key", "", "coil-base_release"})
public final class ContentUriFetcher
implements Fetcher<Uri> {
    private final Context context;

    @Override
    public boolean handles(@NotNull Uri data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return Intrinsics.areEqual((Object)data.getScheme(), (Object)"content");
    }

    @Override
    @NotNull
    public String key(@NotNull Uri data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"data.toString()");
        return string;
    }

    @Override
    @Nullable
    public Object fetch(@NotNull BitmapPool pool, @NotNull Uri data, @NotNull Size size, @NotNull Options options, @NotNull Continuation<? super FetchResult> $completion) {
        InputStream inputStream;
        boolean bl;
        boolean bl2;
        InputStream stream;
        if (this.isContactPhotoUri$coil_base_release(data)) {
            AssetFileDescriptor assetFileDescriptor = this.context.getContentResolver().openAssetFileDescriptor(data, "r");
            stream = assetFileDescriptor != null ? assetFileDescriptor.createInputStream() : null;
            bl2 = false;
            bl = false;
            if (stream == null) {
                boolean bl3 = false;
                String string = "Unable to find a contact photo associated with '" + data + "'.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            inputStream = stream;
        } else {
            stream = this.context.getContentResolver().openInputStream(data);
            bl2 = false;
            bl = false;
            if (stream == null) {
                boolean bl4 = false;
                String string = "Unable to open '" + data + "'.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            inputStream = stream;
        }
        InputStream inputStream2 = inputStream;
        return new SourceResult(Okio.buffer((Source)Okio.source((InputStream)inputStream2)), this.context.getContentResolver().getType(data), DataSource.DISK);
    }

    @VisibleForTesting
    public final boolean isContactPhotoUri$coil_base_release(@NotNull Uri data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return Intrinsics.areEqual((Object)data.getAuthority(), (Object)"com.android.contacts") && Intrinsics.areEqual((Object)data.getLastPathSegment(), (Object)"display_photo");
    }

    public ContentUriFetcher(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }
}

