/*
 * Decompiled with CFR 0.152.
 */
package coil.fetch;

import android.os.NetworkOnMainThreadException;
import android.webkit.MimeTypeMap;
import androidx.annotation.VisibleForTesting;
import coil.bitmap.BitmapPool;
import coil.decode.DataSource;
import coil.decode.Options;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.fetch.HttpFetcher;
import coil.fetch.SourceResult;
import coil.network.HttpException;
import coil.size.Size;
import coil.util.-Extensions;
import coil.util.ContinuationCallback;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.MainCoroutineDispatcher;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u0000 \u0019*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0019B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J1\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u001f\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b\u0016J\u0011\u0010\u0017\u001a\u00020\u0013*\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lcoil/fetch/HttpFetcher;", "T", "", "Lcoil/fetch/Fetcher;", "callFactory", "Lokhttp3/Call$Factory;", "(Lokhttp3/Call$Factory;)V", "fetch", "Lcoil/fetch/FetchResult;", "pool", "Lcoil/bitmap/BitmapPool;", "data", "size", "Lcoil/size/Size;", "options", "Lcoil/decode/Options;", "(Lcoil/bitmap/BitmapPool;Ljava/lang/Object;Lcoil/size/Size;Lcoil/decode/Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMimeType", "", "Lokhttp3/HttpUrl;", "body", "Lokhttp3/ResponseBody;", "getMimeType$coil_base_release", "toHttpUrl", "(Ljava/lang/Object;)Lokhttp3/HttpUrl;", "Companion", "coil-base_release"})
public abstract class HttpFetcher<T>
implements Fetcher<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Call.Factory callFactory;
    @NotNull
    private static final String MIME_TYPE_TEXT_PLAIN = "text/plain";
    private static final CacheControl CACHE_CONTROL_FORCE_NETWORK_NO_CACHE = new CacheControl.Builder().noCache().noStore().build();
    private static final CacheControl CACHE_CONTROL_NO_NETWORK_NO_CACHE = new CacheControl.Builder().noCache().onlyIfCached().build();

    public HttpFetcher(@NotNull Call.Factory callFactory) {
        Intrinsics.checkNotNullParameter((Object)callFactory, (String)"callFactory");
        this.callFactory = callFactory;
    }

    @NotNull
    public abstract HttpUrl toHttpUrl(@NotNull T var1);

    @Override
    @Nullable
    public Object fetch(@NotNull BitmapPool pool, @NotNull T data, @NotNull Size size2, @NotNull Options options, @NotNull Continuation<? super FetchResult> $completion) {
        return HttpFetcher.fetch$suspendImpl(this, pool, data, size2, options, $completion);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Object fetch$suspendImpl(HttpFetcher var0, BitmapPool var1_1, Object var2_2, Size var3_3, Options var4_4, Continuation var5_5) {
        if (!(var5_5 instanceof fetch.1)) ** GOTO lbl-1000
        var21_6 = var5_5;
        if ((var21_6.label & -2147483648) != 0) {
            var21_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, (Continuation<? super fetch.1>)var5_5){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ HttpFetcher<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpFetcher.fetch$suspendImpl(this.this$0, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var22_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                url = this.toHttpUrl(data);
                request = new Request.Builder().url(url).headers(options.getHeaders());
                networkRead = options.getNetworkCachePolicy().getReadEnabled();
                diskRead = options.getDiskCachePolicy().getReadEnabled();
                if (!networkRead && diskRead) {
                    request.cacheControl(CacheControl.FORCE_CACHE);
                } else if (networkRead && !diskRead) {
                    if (options.getDiskCachePolicy().getWriteEnabled()) {
                        request.cacheControl(CacheControl.FORCE_NETWORK);
                    } else {
                        request.cacheControl(HttpFetcher.CACHE_CONTROL_FORCE_NETWORK_NO_CACHE);
                    }
                } else if (!networkRead && !diskRead) {
                    request.cacheControl(HttpFetcher.CACHE_CONTROL_NO_NETWORK_NO_CACHE);
                }
                if (!($continuation.getContext().get((CoroutineContext.Key)CoroutineDispatcher.Key) instanceof MainCoroutineDispatcher)) ** GOTO lbl37
                if (networkRead) {
                    throw new NetworkOnMainThreadException();
                }
                v0 = this.callFactory.newCall(request.build()).execute();
                ** GOTO lbl74
lbl37:
                // 1 sources

                var11_13 = this.callFactory.newCall(request.build());
                Intrinsics.checkNotNullExpressionValue((Object)var11_13, (String)"callFactory.newCall(request.build())");
                $this$await$iv = var11_13;
                $i$f$await = false;
                $i$f$suspendCancellableCoroutine = false;
                $continuation.L$0 = this;
                $continuation.L$1 = url;
                $continuation.L$2 = $this$await$iv;
                $continuation.label = 1;
                uCont$iv$iv = $continuation;
                $i$a$-suspendCoroutineUninterceptedOrReturn-CancellableContinuationKt$suspendCancellableCoroutine$2$iv$iv = false;
                cancellable$iv$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv$iv), 1);
                cancellable$iv$iv.initCancellability();
                continuation$iv = (CancellableContinuation)cancellable$iv$iv;
                $i$a$-suspendCancellableCoroutine--Calls$await$2$iv = false;
                callback$iv = new ContinuationCallback($this$await$iv, (CancellableContinuation<? super Response>)continuation$iv);
                $this$await$iv.enqueue((Callback)callback$iv);
                continuation$iv.invokeOnCancellation((Function1)callback$iv);
                v1 = cancellable$iv$iv.getResult();
                if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)$continuation);
                }
                v2 = v1;
                if (v1 == var22_8) {
                    return var22_8;
                }
                ** GOTO lbl73
            }
            case 1: {
                $i$f$await = false;
                $i$f$suspendCancellableCoroutine = false;
                $this$await$iv = (Call)$continuation.L$2;
                url = (HttpUrl)$continuation.L$1;
                this = (HttpFetcher)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl73:
                // 2 sources

                v0 = response = (Response)v2;
lbl74:
                // 2 sources

                if (!response.isSuccessful()) {
                    $this$await$iv = response.body();
                    if ($this$await$iv != null) {
                        $this$await$iv.close();
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                    throw new HttpException(response);
                }
                var13_17 = response.body();
                var14_19 = false;
                var15_20 = false;
                if (var13_17 == null) {
                    $i$a$-checkNotNull-HttpFetcher$fetch$body$1 = false;
                    var15_21 = "Null response body!";
                    throw (Throwable)new IllegalStateException(var15_21.toString());
                }
                body = var12_15 = var13_17;
                var12_15 = body.source();
                Intrinsics.checkNotNullExpressionValue((Object)var12_15, (String)"body.source()");
                return new SourceResult((BufferedSource)var12_15, this.getMimeType$coil_base_release(url, body), response.cacheResponse() != null ? DataSource.DISK : DataSource.NETWORK);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @VisibleForTesting
    @Nullable
    public final String getMimeType$coil_base_release(@NotNull HttpUrl data, @NotNull ResponseBody body) {
        String rawContentType;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Object object = body.contentType();
        String string = rawContentType = object == null ? null : object.toString();
        if (rawContentType == null || StringsKt.startsWith$default((String)rawContentType, (String)MIME_TYPE_TEXT_PLAIN, (boolean)false, (int)2, null)) {
            MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
            Intrinsics.checkNotNullExpressionValue((Object)mimeTypeMap, (String)"getSingleton()");
            object = -Extensions.getMimeTypeFromUrl(mimeTypeMap, data.toString());
            if (object != null) {
                mimeTypeMap = object;
                boolean bl = false;
                boolean bl2 = false;
                MimeTypeMap it = mimeTypeMap;
                boolean bl3 = false;
                return it;
            }
        }
        return (object = rawContentType) == null ? null : StringsKt.substringBefore$default((String)object, (char)';', null, (int)2, null);
    }

    @Override
    public boolean handles(@NotNull T data) {
        return Fetcher.DefaultImpls.handles(this, data);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcoil/fetch/HttpFetcher$Companion;", "", "()V", "CACHE_CONTROL_FORCE_NETWORK_NO_CACHE", "Lokhttp3/CacheControl;", "kotlin.jvm.PlatformType", "CACHE_CONTROL_NO_NETWORK_NO_CACHE", "MIME_TYPE_TEXT_PLAIN", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

