/*
 * Decompiled with CFR 0.152.
 */
package coil.util;

import android.app.ActivityManager;
import android.content.Context;
import androidx.core.content.ContextCompat;
import coil.disk.DiskCache;
import coil.util.-Utils;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcoil/util/Utils;", "", "()V", "DEFAULT_MEMORY_CLASS_MEGABYTES", "", "LOW_MEMORY_MULTIPLIER", "", "SINGLETON_DISK_CACHE_NAME", "", "STANDARD_MEMORY_MULTIPLIER", "singletonDiskCache", "Lcoil/disk/DiskCache;", "calculateMemoryCacheSize", "context", "Landroid/content/Context;", "percent", "defaultMemoryCacheSizePercent", "coil-base_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    private static final double STANDARD_MEMORY_MULTIPLIER = 0.2;
    private static final double LOW_MEMORY_MULTIPLIER = 0.15;
    private static final int DEFAULT_MEMORY_CLASS_MEGABYTES = 256;
    @NotNull
    private static final String SINGLETON_DISK_CACHE_NAME = "image_cache";
    @Nullable
    private static DiskCache singletonDiskCache;

    private Utils() {
    }

    public final int calculateMemoryCacheSize(@NotNull Context context, double percent) {
        int n;
        try {
            Context $this$requireSystemService$iv = context;
            boolean $i$f$requireSystemService = false;
            Context $this$getSystemService$iv$iv = $this$requireSystemService$iv;
            boolean $i$f$getSystemService = false;
            Object object = ContextCompat.getSystemService((Context)$this$getSystemService$iv$iv, ActivityManager.class);
            boolean bl = false;
            boolean bl2 = false;
            if (object == null) {
                boolean bl3 = false;
                String string = "System service of type " + ActivityManager.class + " was not found.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ActivityManager activityManager = (ActivityManager)object;
            boolean isLargeHeap = (context.getApplicationInfo().flags & 0x100000) != 0;
            n = isLargeHeap ? activityManager.getLargeMemoryClass() : activityManager.getMemoryClass();
        }
        catch (Exception _) {
            n = 256;
        }
        int memoryClassMegabytes = n;
        return (int)(percent * (double)memoryClassMegabytes * (double)1024 * (double)1024);
    }

    public final double defaultMemoryCacheSizePercent(@NotNull Context context) {
        double d;
        try {
            Context $this$requireSystemService$iv = context;
            boolean $i$f$requireSystemService = false;
            Context $this$getSystemService$iv$iv = $this$requireSystemService$iv;
            boolean $i$f$getSystemService = false;
            Object object = ContextCompat.getSystemService((Context)$this$getSystemService$iv$iv, ActivityManager.class);
            boolean bl = false;
            boolean bl2 = false;
            if (object == null) {
                boolean bl3 = false;
                String string = "System service of type " + ActivityManager.class + " was not found.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ActivityManager activityManager = (ActivityManager)object;
            d = activityManager.isLowRamDevice() ? 0.15 : 0.2;
        }
        catch (Exception _) {
            d = 0.2;
        }
        return d;
    }

    @NotNull
    public final synchronized DiskCache singletonDiskCache(@NotNull Context context) {
        DiskCache diskCache;
        DiskCache diskCache2 = singletonDiskCache;
        if (diskCache2 == null) {
            Utils utils = this;
            boolean bl = false;
            boolean bl2 = false;
            Utils $this$singletonDiskCache_u24lambda_u2d1 = utils;
            boolean bl3 = false;
            DiskCache diskCache3 = new DiskCache.Builder(context).directory(FilesKt.resolve((File)-Utils.getSafeCacheDir(context), (String)SINGLETON_DISK_CACHE_NAME)).build();
            boolean bl4 = false;
            boolean bl5 = false;
            DiskCache it = diskCache3;
            boolean bl6 = false;
            singletonDiskCache = it;
            diskCache = diskCache3;
        } else {
            diskCache = diskCache2;
        }
        return diskCache;
    }
}

