/*
 * Decompiled with CFR 0.152.
 */
package coil.disk;

import coil.disk.DiskLruCache;
import coil.disk.FaultHidingSink;
import coil.util.-FileSystems;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.ForwardingFileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000s\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0014*\u0001\u0014\b\u0000\u0018\u0000 B2\u00060\u0001j\u0002`\u0002:\u0004BCDEB5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020'H\u0016J\u001c\u0010)\u001a\u00020'2\n\u0010*\u001a\u00060+R\u00020\u00002\u0006\u0010,\u001a\u00020\u0010H\u0002J\u0006\u0010-\u001a\u00020'J\u0014\u0010.\u001a\b\u0018\u00010+R\u00020\u00002\u0006\u0010/\u001a\u00020\u001fJ\u0006\u00100\u001a\u00020'J\u0017\u00101\u001a\b\u0018\u000102R\u00020\u00002\u0006\u0010/\u001a\u00020\u001fH\u0086\u0002J\b\u00103\u001a\u00020'H\u0002J\b\u00104\u001a\u00020\u0010H\u0002J\b\u00105\u001a\u00020\u001cH\u0002J\b\u00106\u001a\u00020'H\u0002J\b\u00107\u001a\u00020'H\u0002J\u0010\u00108\u001a\u00020'2\u0006\u00109\u001a\u00020\u001fH\u0002J\b\u0010:\u001a\u00020'H\u0002J\u000e\u0010;\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u001fJ\u0014\u0010<\u001a\u00020\u00102\n\u0010=\u001a\u00060 R\u00020\u0000H\u0002J\b\u0010>\u001a\u00020\u0010H\u0002J\b\u0010?\u001a\u00020'H\u0002J\u0006\u0010%\u001a\u00020\nJ\b\u0010@\u001a\u00020'H\u0002J\u0010\u0010A\u001a\u00020'2\u0006\u0010/\u001a\u00020\u001fH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u001d\u001a&\u0012\u0004\u0012\u00020\u001f\u0012\b\u0012\u00060 R\u00020\u00000\u001ej\u0012\u0012\u0004\u0012\u00020\u001f\u0012\b\u0012\u00060 R\u00020\u0000`!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcoil/disk/DiskLruCache;", "Ljava/io/Closeable;", "Lokio/Closeable;", "fileSystem", "Lokio/FileSystem;", "directory", "Lokio/Path;", "cleanupDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "maxSize", "", "appVersion", "", "valueCount", "(Lokio/FileSystem;Lokio/Path;Lkotlinx/coroutines/CoroutineDispatcher;JII)V", "cleanupScheduled", "", "cleanupScope", "Lkotlinx/coroutines/CoroutineScope;", "closed", "coil/disk/DiskLruCache$fileSystem$1", "Lcoil/disk/DiskLruCache$fileSystem$1;", "hasJournalErrors", "initialized", "journalFile", "journalFileBackup", "journalFileTmp", "journalWriter", "Lokio/BufferedSink;", "lruEntries", "Ljava/util/LinkedHashMap;", "", "Lcoil/disk/DiskLruCache$Entry;", "Lkotlin/collections/LinkedHashMap;", "mostRecentRebuildFailed", "mostRecentTrimFailed", "redundantOpCount", "size", "checkNotClosed", "", "close", "completeEdit", "editor", "Lcoil/disk/DiskLruCache$Editor;", "success", "delete", "edit", "key", "evictAll", "get", "Lcoil/disk/DiskLruCache$Snapshot;", "initialize", "journalRebuildRequired", "newJournalWriter", "processJournal", "readJournal", "readJournalLine", "line", "rebuildJournal", "remove", "removeEntry", "entry", "removeOldestEntry", "scheduleCleanup", "trimToSize", "validateKey", "Companion", "Editor", "Entry", "Snapshot", "coil-base_release"})
public final class DiskLruCache
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path directory;
    private final long maxSize;
    private final int appVersion;
    private final int valueCount;
    @NotNull
    private final Path journalFile;
    @NotNull
    private final Path journalFileTmp;
    @NotNull
    private final Path journalFileBackup;
    @NotNull
    private final LinkedHashMap<String, Entry> lruEntries;
    private long size;
    private int redundantOpCount;
    @Nullable
    private BufferedSink journalWriter;
    private boolean hasJournalErrors;
    private boolean initialized;
    private boolean closed;
    private boolean mostRecentTrimFailed;
    private boolean mostRecentRebuildFailed;
    @NotNull
    private final CoroutineScope cleanupScope;
    private boolean cleanupScheduled;
    @NotNull
    private final fileSystem.1 fileSystem;
    @NotNull
    private static final String JOURNAL_FILE = "journal";
    @NotNull
    private static final String JOURNAL_FILE_TEMP = "journal.tmp";
    @NotNull
    private static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    @NotNull
    private static final String MAGIC = "libcore.io.DiskLruCache";
    @NotNull
    private static final String VERSION = "1";
    @NotNull
    private static final String CLEAN = "CLEAN";
    @NotNull
    private static final String DIRTY = "DIRTY";
    @NotNull
    private static final String REMOVE = "REMOVE";
    @NotNull
    private static final String READ = "READ";
    @NotNull
    private static final Regex LEGAL_KEY_PATTERN;

    public DiskLruCache(@NotNull FileSystem fileSystem2, @NotNull Path directory, @NotNull CoroutineDispatcher cleanupDispatcher, long maxSize, int appVersion, int valueCount) {
        this.directory = directory;
        this.maxSize = maxSize;
        this.appVersion = appVersion;
        this.valueCount = valueCount;
        this.lruEntries = new LinkedHashMap(0, 0.75f, true);
        this.cleanupScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)cleanupDispatcher));
        this.fileSystem = new ForwardingFileSystem(fileSystem2){
            final /* synthetic */ FileSystem $fileSystem;
            {
                this.$fileSystem = $fileSystem;
                super($fileSystem);
            }

            @NotNull
            public Sink sink(@NotNull Path file, boolean mustCreate) {
                Path path = file.parent();
                if (path != null) {
                    Path path2 = path;
                    boolean bl = false;
                    boolean bl2 = false;
                    Path p0 = path2;
                    boolean bl3 = false;
                    this.createDirectories(p0);
                }
                return super.sink(file, mustCreate);
            }
        };
        boolean bl = this.maxSize > 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "maxSize <= 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.valueCount > 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "valueCount <= 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.journalFile = this.directory.resolve(JOURNAL_FILE);
        this.journalFileTmp = this.directory.resolve(JOURNAL_FILE_TEMP);
        this.journalFileBackup = this.directory.resolve(JOURNAL_FILE_BACKUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        if (this.fileSystem.exists(this.journalFileBackup)) {
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.delete(this.journalFileBackup);
            } else {
                this.fileSystem.atomicMove(this.journalFileBackup, this.journalFile);
            }
        }
        if (this.fileSystem.exists(this.journalFile)) {
            try {
                this.readJournal();
                this.processJournal();
                this.initialized = true;
                return;
            }
            catch (IOException iOException) {
                try {
                    this.delete();
                }
                finally {
                    this.closed = false;
                }
            }
        }
        this.rebuildJournal();
        this.initialized = true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readJournal() {
        void this_$iv;
        FileSystem fileSystem2 = (FileSystem)this.fileSystem;
        Path file$iv = this.journalFile;
        boolean bl = false;
        Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
        boolean $i$f$use = false;
        Unit result$iv$iv = null;
        Throwable thrown$iv$iv = null;
        try {
            int n;
            BufferedSource $this$readJournal_u24lambda_u2d2;
            block18: {
                String blank;
                String valueCountString;
                String appVersionString;
                String version;
                String magic;
                block17: {
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean bl2 = false;
                    $this$readJournal_u24lambda_u2d2 = it$iv;
                    boolean bl3 = false;
                    magic = $this$readJournal_u24lambda_u2d2.readUtf8LineStrict();
                    version = $this$readJournal_u24lambda_u2d2.readUtf8LineStrict();
                    appVersionString = $this$readJournal_u24lambda_u2d2.readUtf8LineStrict();
                    valueCountString = $this$readJournal_u24lambda_u2d2.readUtf8LineStrict();
                    blank = $this$readJournal_u24lambda_u2d2.readUtf8LineStrict();
                    if (!Intrinsics.areEqual((Object)MAGIC, (Object)magic) || !Intrinsics.areEqual((Object)VERSION, (Object)version) || !Intrinsics.areEqual((Object)String.valueOf(this.appVersion), (Object)appVersionString) || !Intrinsics.areEqual((Object)String.valueOf(this.valueCount), (Object)valueCountString)) break block17;
                    CharSequence charSequence = blank;
                    n = 0;
                    if (!(charSequence.length() > 0)) break block18;
                }
                throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + ']');
            }
            int lineCount = 0;
            try {
                while (true) {
                    this.readJournalLine($this$readJournal_u24lambda_u2d2.readUtf8LineStrict());
                    n = lineCount;
                    lineCount = n + 1;
                }
            }
            catch (EOFException _) {
                this.redundantOpCount = lineCount - this.lruEntries.size();
                if (!$this$readJournal_u24lambda_u2d2.exhausted()) {
                    this.rebuildJournal();
                } else {
                    this.journalWriter = this.newJournalWriter();
                }
                result$iv$iv = Unit.INSTANCE;
            }
        }
        catch (Throwable t$iv$iv) {
            thrown$iv$iv = t$iv$iv;
        }
        try {
            Closeable t$iv$iv = $this$use$iv$iv;
            if (t$iv$iv != null) {
                t$iv$iv.close();
            }
        }
        catch (Throwable t$iv$iv) {
            if (thrown$iv$iv == null) {
                thrown$iv$iv = t$iv$iv;
            }
            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
        }
        if (thrown$iv$iv != null) {
            throw thrown$iv$iv;
        }
        Intrinsics.checkNotNull(result$iv$iv);
    }

    private final BufferedSink newJournalWriter() {
        Sink fileSink = this.fileSystem.appendingSink(this.journalFile);
        FaultHidingSink faultHidingSink2 = new FaultHidingSink(fileSink, (Function1<? super IOException, Unit>)((Function1)new Function1<IOException, Unit>(this){
            final /* synthetic */ DiskLruCache this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull IOException it) {
                DiskLruCache.access$setHasJournalErrors$p(this.this$0, true);
            }
        }));
        return Okio.buffer((Sink)((Sink)faultHidingSink2));
    }

    private final void readJournalLine(String line) {
        Object object;
        boolean bl;
        String string;
        int firstSpace = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)0, (boolean)false, (int)6, null);
        if (firstSpace == -1) {
            throw new IOException(Intrinsics.stringPlus((String)"unexpected journal line: ", (Object)line));
        }
        int keyBegin = firstSpace + 1;
        int secondSpace = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)keyBegin, (boolean)false, (int)4, null);
        String key = null;
        if (secondSpace == -1) {
            string = line;
            bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(keyBegin);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            key = string3;
            if (firstSpace == REMOVE.length() && StringsKt.startsWith$default((String)line, (String)REMOVE, (boolean)false, (int)2, null)) {
                this.lruEntries.remove(key);
                return;
            }
        } else {
            string = line;
            bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(keyBegin, secondSpace);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            key = string5;
        }
        Map $this$getOrPut$iv = this.lruEntries;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl2 = false;
            Entry answer$iv = new Entry(key);
            $this$getOrPut$iv.put(key, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Entry entry = (Entry)object;
        if (secondSpace != -1 && firstSpace == CLEAN.length() && StringsKt.startsWith$default((String)line, (String)CLEAN, (boolean)false, (int)2, null)) {
            Object object2 = line;
            int n = secondSpace + 1;
            boolean bl3 = false;
            String string6 = object2;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            object2 = new char[1];
            object2[0] = 32;
            List parts = StringsKt.split$default((CharSequence)string7, (char[])object2, (boolean)false, (int)0, (int)6, null);
            entry.setReadable(true);
            entry.setCurrentEditor(null);
            entry.setLengths(parts);
        } else if (secondSpace == -1 && firstSpace == DIRTY.length() && StringsKt.startsWith$default((String)line, (String)DIRTY, (boolean)false, (int)2, null)) {
            entry.setCurrentEditor(new Editor(entry));
        } else if (secondSpace != -1 || firstSpace != READ.length() || !StringsKt.startsWith$default((String)line, (String)READ, (boolean)false, (int)2, null)) {
            throw new IOException(Intrinsics.stringPlus((String)"unexpected journal line: ", (Object)line));
        }
    }

    private final void processJournal() {
        -FileSystems.deleteIfExists((FileSystem)this.fileSystem, this.journalFileTmp);
        Iterator<Entry> i = this.lruEntries.values().iterator();
        while (i.hasNext()) {
            int t;
            int n;
            int n2;
            Entry entry = i.next();
            if (entry.getCurrentEditor() == null) {
                n2 = 0;
                n = this.valueCount;
                if (n2 >= n) continue;
                do {
                    t = n2++;
                    DiskLruCache diskLruCache = this;
                    diskLruCache.size += entry.getLengths()[t];
                } while (n2 < n);
                continue;
            }
            entry.setCurrentEditor(null);
            n2 = 0;
            n = this.valueCount;
            if (n2 < n) {
                do {
                    t = n2++;
                    -FileSystems.deleteIfExists((FileSystem)this.fileSystem, entry.getCleanFiles().get(t));
                    -FileSystems.deleteIfExists((FileSystem)this.fileSystem, entry.getDirtyFiles().get(t));
                } while (n2 < n);
            }
            i.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void rebuildJournal() {
        void this_$iv;
        BufferedSink bufferedSink = this.journalWriter;
        if (bufferedSink != null) {
            bufferedSink.close();
        }
        bufferedSink = (FileSystem)this.fileSystem;
        Path file$iv = this.journalFileTmp;
        boolean mustCreate$iv = false;
        boolean bl = false;
        Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)this_$iv.sink(file$iv, mustCreate$iv));
        boolean $i$f$use = false;
        Unit result$iv$iv = null;
        Throwable thrown$iv$iv = null;
        try {
            BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
            boolean bl2 = false;
            BufferedSink $this$rebuildJournal_u24lambda_u2d4 = it$iv;
            boolean bl3 = false;
            int n = 10;
            boolean bl4 = false;
            $this$rebuildJournal_u24lambda_u2d4.writeUtf8(MAGIC).writeByte(n);
            n = 10;
            bl4 = false;
            $this$rebuildJournal_u24lambda_u2d4.writeUtf8(VERSION).writeByte(n);
            n = 10;
            bl4 = false;
            $this$rebuildJournal_u24lambda_u2d4.writeDecimalLong((long)this.appVersion).writeByte(n);
            n = 10;
            bl4 = false;
            $this$rebuildJournal_u24lambda_u2d4.writeDecimalLong((long)this.valueCount).writeByte(n);
            n = 10;
            bl4 = false;
            $this$rebuildJournal_u24lambda_u2d4.writeByte(n);
            for (Entry entry : this.lruEntries.values()) {
                boolean bl5;
                int n2;
                if (entry.getCurrentEditor() != null) {
                    n2 = 32;
                    bl5 = false;
                    $this$rebuildJournal_u24lambda_u2d4.writeUtf8(DIRTY).writeByte(n2);
                    $this$rebuildJournal_u24lambda_u2d4.writeUtf8(entry.getKey());
                    n2 = 10;
                    bl5 = false;
                    $this$rebuildJournal_u24lambda_u2d4.writeByte(n2);
                    continue;
                }
                n2 = 32;
                bl5 = false;
                $this$rebuildJournal_u24lambda_u2d4.writeUtf8(CLEAN).writeByte(n2);
                $this$rebuildJournal_u24lambda_u2d4.writeUtf8(entry.getKey());
                entry.writeLengths($this$rebuildJournal_u24lambda_u2d4);
                n2 = 10;
                bl5 = false;
                $this$rebuildJournal_u24lambda_u2d4.writeByte(n2);
            }
            result$iv$iv = Unit.INSTANCE;
        }
        catch (Throwable t$iv$iv) {
            thrown$iv$iv = t$iv$iv;
        }
        try {
            Closeable t$iv$iv = $this$use$iv$iv;
            if (t$iv$iv != null) {
                t$iv$iv.close();
            }
        }
        catch (Throwable t$iv$iv) {
            if (thrown$iv$iv == null) {
                thrown$iv$iv = t$iv$iv;
            }
            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
        }
        if (thrown$iv$iv != null) {
            throw thrown$iv$iv;
        }
        Intrinsics.checkNotNull(result$iv$iv);
        if (this.fileSystem.exists(this.journalFile)) {
            this.fileSystem.atomicMove(this.journalFile, this.journalFileBackup);
            this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
            -FileSystems.deleteIfExists((FileSystem)this.fileSystem, this.journalFileBackup);
        } else {
            this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
        }
        this.journalWriter = this.newJournalWriter();
        this.hasJournalErrors = false;
        this.mostRecentRebuildFailed = false;
    }

    @Nullable
    public final synchronized Snapshot get(@NotNull String key) {
        Closeable closeable;
        this.initialize();
        this.checkNotClosed();
        this.validateKey(key);
        Entry entry = this.lruEntries.get(key);
        Snapshot snapshot = closeable = entry == null ? null : entry.snapshot();
        if (closeable == null) {
            return null;
        }
        Snapshot snapshot2 = closeable;
        closeable = this;
        int n = ((DiskLruCache)closeable).redundantOpCount;
        ((DiskLruCache)closeable).redundantOpCount = n + 1;
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        closeable = bufferedSink;
        n = 0;
        boolean bl = false;
        Closeable $this$get_u24lambda_u2d5 = closeable;
        boolean bl2 = false;
        $this$get_u24lambda_u2d5.writeUtf8(READ);
        int n2 = 32;
        boolean bl3 = false;
        $this$get_u24lambda_u2d5.writeByte(n2);
        $this$get_u24lambda_u2d5.writeUtf8(key);
        n2 = 10;
        bl3 = false;
        $this$get_u24lambda_u2d5.writeByte(n2);
        if (this.journalRebuildRequired()) {
            this.scheduleCleanup();
        }
        return snapshot2;
    }

    @Nullable
    public final synchronized Editor edit(@NotNull String key) {
        this.initialize();
        this.checkNotClosed();
        this.validateKey(key);
        Entry entry = this.lruEntries.get(key);
        Object object = entry;
        if ((object == null ? null : ((Entry)object).getCurrentEditor()) != null) {
            return null;
        }
        if (entry != null && entry.getLockingSnapshotCount() != 0) {
            return null;
        }
        if (this.mostRecentTrimFailed || this.mostRecentRebuildFailed) {
            this.scheduleCleanup();
            return null;
        }
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        object = bufferedSink;
        boolean bl = false;
        boolean bl2 = false;
        Entry $this$edit_u24lambda_u2d6 = object;
        boolean bl3 = false;
        $this$edit_u24lambda_u2d6.writeUtf8(DIRTY);
        int n = 32;
        boolean bl4 = false;
        $this$edit_u24lambda_u2d6.writeByte(n);
        $this$edit_u24lambda_u2d6.writeUtf8(key);
        n = 10;
        bl4 = false;
        $this$edit_u24lambda_u2d6.writeByte(n);
        $this$edit_u24lambda_u2d6.flush();
        if (this.hasJournalErrors) {
            return null;
        }
        if (entry == null) {
            entry = new Entry(key);
            object = this.lruEntries;
            bl = false;
            object.put(key, entry);
        }
        Editor editor = new Editor(entry);
        entry.setCurrentEditor(editor);
        return editor;
    }

    public final synchronized long size() {
        this.initialize();
        return this.size;
    }

    private final synchronized void completeEdit(Editor editor, boolean success) {
        int i;
        Entry entry = editor.getEntry();
        int n = Intrinsics.areEqual((Object)entry.getCurrentEditor(), (Object)editor);
        int n2 = 0;
        boolean bl = false;
        bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        n = 0;
        n2 = this.valueCount;
        if (n < n2) {
            do {
                i = n++;
                Path dirty = entry.getDirtyFiles().get(i);
                if (success && !entry.getZombie()) {
                    long newLength;
                    if (!this.fileSystem.exists(dirty)) continue;
                    Path clean = entry.getCleanFiles().get(i);
                    this.fileSystem.atomicMove(dirty, clean);
                    long oldLength = entry.getLengths()[i];
                    Long l = this.fileSystem.metadata(clean).getSize();
                    entry.getLengths()[i] = newLength = l == null ? 0L : l;
                    this.size = this.size - oldLength + newLength;
                    continue;
                }
                -FileSystems.deleteIfExists((FileSystem)this.fileSystem, dirty);
            } while (n < n2);
        }
        if (success && (n = 0) < (n2 = this.valueCount)) {
            do {
                i = n++;
                entry.getCleanFiles().get(i).toFile().createNewFile();
            } while (n < n2);
        }
        entry.setCurrentEditor(null);
        if (entry.getZombie()) {
            this.removeEntry(entry);
            return;
        }
        DiskLruCache diskLruCache = this;
        n2 = diskLruCache.redundantOpCount;
        diskLruCache.redundantOpCount = n2 + 1;
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        diskLruCache = bufferedSink;
        n2 = 0;
        bl = false;
        DiskLruCache $this$completeEdit_u24lambda_u2d7 = diskLruCache;
        boolean bl4 = false;
        if (entry.getReadable() || success) {
            entry.setReadable(true);
            int n3 = 32;
            boolean bl5 = false;
            $this$completeEdit_u24lambda_u2d7.writeUtf8(CLEAN).writeByte(n3);
            $this$completeEdit_u24lambda_u2d7.writeUtf8(entry.getKey());
            entry.writeLengths((BufferedSink)$this$completeEdit_u24lambda_u2d7);
            n3 = 10;
            bl5 = false;
            $this$completeEdit_u24lambda_u2d7.writeByte(n3);
        } else {
            this.lruEntries.remove(entry.getKey());
            int n4 = 32;
            boolean bl6 = false;
            $this$completeEdit_u24lambda_u2d7.writeUtf8(REMOVE).writeByte(n4);
            $this$completeEdit_u24lambda_u2d7.writeUtf8(entry.getKey());
            n4 = 10;
            bl6 = false;
            $this$completeEdit_u24lambda_u2d7.writeByte(n4);
        }
        $this$completeEdit_u24lambda_u2d7.flush();
        if (this.size > this.maxSize || this.journalRebuildRequired()) {
            this.scheduleCleanup();
        }
    }

    private final boolean journalRebuildRequired() {
        return this.redundantOpCount >= 2000 && this.redundantOpCount >= this.lruEntries.size();
    }

    public final synchronized boolean remove(@NotNull String key) {
        this.initialize();
        this.checkNotClosed();
        this.validateKey(key);
        Entry entry = this.lruEntries.get(key);
        if (entry == null) {
            return false;
        }
        Entry entry2 = entry;
        boolean removed = this.removeEntry(entry2);
        if (removed && this.size <= this.maxSize) {
            this.mostRecentTrimFailed = false;
        }
        return removed;
    }

    private final boolean removeEntry(Entry entry) {
        boolean bl;
        int n;
        boolean bl2;
        boolean bl3;
        Object object;
        if (entry.getLockingSnapshotCount() > 0 && (object = this.journalWriter) != null) {
            BufferedSink bufferedSink = object;
            bl3 = false;
            bl2 = false;
            BufferedSink $this$removeEntry_u24lambda_u2d8 = bufferedSink;
            boolean bl4 = false;
            $this$removeEntry_u24lambda_u2d8.writeUtf8(DIRTY);
            n = 32;
            bl = false;
            $this$removeEntry_u24lambda_u2d8.writeByte(n);
            $this$removeEntry_u24lambda_u2d8.writeUtf8(entry.getKey());
            n = 10;
            bl = false;
            $this$removeEntry_u24lambda_u2d8.writeByte(n);
            $this$removeEntry_u24lambda_u2d8.flush();
        }
        if (entry.getLockingSnapshotCount() > 0 || entry.getCurrentEditor() != null) {
            entry.setZombie(true);
            return true;
        }
        object = entry.getCurrentEditor();
        if (object != null) {
            ((Editor)object).detach();
        }
        int n2 = 0;
        int n3 = this.valueCount;
        if (n2 < n3) {
            do {
                int i = n2++;
                -FileSystems.deleteIfExists((FileSystem)this.fileSystem, entry.getCleanFiles().get(i));
                DiskLruCache diskLruCache = this;
                diskLruCache.size -= entry.getLengths()[i];
                entry.getLengths()[i] = 0L;
            } while (n2 < n3);
        }
        DiskLruCache diskLruCache = this;
        n3 = diskLruCache.redundantOpCount;
        diskLruCache.redundantOpCount = n3 + 1;
        diskLruCache = this.journalWriter;
        if (diskLruCache != null) {
            DiskLruCache diskLruCache2 = diskLruCache;
            bl3 = false;
            bl2 = false;
            DiskLruCache $this$removeEntry_u24lambda_u2d9 = diskLruCache2;
            boolean bl5 = false;
            $this$removeEntry_u24lambda_u2d9.writeUtf8(REMOVE);
            n = 32;
            bl = false;
            $this$removeEntry_u24lambda_u2d9.writeByte(n);
            $this$removeEntry_u24lambda_u2d9.writeUtf8(entry.getKey());
            n = 10;
            bl = false;
            $this$removeEntry_u24lambda_u2d9.writeByte(n);
        }
        this.lruEntries.remove(entry.getKey());
        if (this.journalRebuildRequired()) {
            this.scheduleCleanup();
        }
        return true;
    }

    private final void checkNotClosed() {
        boolean bl = !this.closed;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "cache is closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @Override
    public synchronized void close() {
        if (!this.initialized || this.closed) {
            this.closed = true;
            return;
        }
        Collection<Entry> $this$toTypedArray$iv = this.lruEntries.values();
        boolean $i$f$toTypedArray = false;
        Collection<Entry> thisCollection$iv = $this$toTypedArray$iv;
        Entry[] entryArray = thisCollection$iv.toArray(new Entry[0]);
        if (entryArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        for (Entry entry : entryArray) {
            Editor editor;
            if (entry.getCurrentEditor() == null || (editor = entry.getCurrentEditor()) == null) continue;
            editor.detach();
        }
        this.trimToSize();
        CoroutineScopeKt.cancel$default((CoroutineScope)this.cleanupScope, null, (int)1, null);
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.close();
        this.journalWriter = null;
        this.closed = true;
    }

    private final void trimToSize() {
        while (this.size > this.maxSize) {
            if (this.removeOldestEntry()) continue;
            return;
        }
        this.mostRecentTrimFailed = false;
    }

    private final boolean removeOldestEntry() {
        for (Entry toEvict : this.lruEntries.values()) {
            if (toEvict.getZombie()) continue;
            this.removeEntry(toEvict);
            return true;
        }
        return false;
    }

    public final void delete() {
        this.close();
        -FileSystems.deleteContents((FileSystem)this.fileSystem, this.directory);
    }

    public final synchronized void evictAll() {
        this.initialize();
        Collection<Entry> $this$toTypedArray$iv = this.lruEntries.values();
        boolean $i$f$toTypedArray = false;
        Collection<Entry> thisCollection$iv = $this$toTypedArray$iv;
        Entry[] entryArray = thisCollection$iv.toArray(new Entry[0]);
        if (entryArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        for (Entry entry : entryArray) {
            this.removeEntry(entry);
        }
        this.mostRecentTrimFailed = false;
    }

    private final synchronized void scheduleCleanup() {
        if (this.cleanupScheduled) {
            return;
        }
        this.cleanupScheduled = true;
        BuildersKt.launch$default((CoroutineScope)this.cleanupScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DiskLruCache this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DiskLruCache diskLruCache = this.this$0;
                        DiskLruCache diskLruCache2 = this.this$0;
                        boolean bl = false;
                        boolean bl2 = false;
                        synchronized (diskLruCache) {
                            boolean bl3 = false;
                            DiskLruCache.access$setCleanupScheduled$p(diskLruCache2, false);
                            if (!DiskLruCache.access$getInitialized$p(diskLruCache2)) return Unit.INSTANCE;
                            if (DiskLruCache.access$getClosed$p(diskLruCache2)) {
                                return Unit.INSTANCE;
                            }
                            try {
                                DiskLruCache.access$trimToSize(diskLruCache2);
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentTrimFailed$p(diskLruCache2, true);
                            }
                            try {
                                if (DiskLruCache.access$journalRebuildRequired(diskLruCache2)) {
                                    DiskLruCache.access$rebuildJournal(diskLruCache2);
                                    DiskLruCache.access$setRedundantOpCount$p(diskLruCache2, 0);
                                }
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentRebuildFailed$p(diskLruCache2, true);
                                DiskLruCache.access$setJournalWriter$p(diskLruCache2, Okio.buffer((Sink)Okio.blackhole()));
                            }
                            Unit unit = Unit.INSTANCE;
                            return Unit.INSTANCE;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void validateKey(String key) {
        boolean bl = LEGAL_KEY_PATTERN.matches((CharSequence)key);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "keys must match regex [a-z0-9_-]{1,120}: \"" + key + '\"';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public static final /* synthetic */ void access$setHasJournalErrors$p(DiskLruCache $this, boolean bl) {
        $this.hasJournalErrors = bl;
    }

    public static final /* synthetic */ void access$setCleanupScheduled$p(DiskLruCache $this, boolean bl) {
        $this.cleanupScheduled = bl;
    }

    public static final /* synthetic */ boolean access$getInitialized$p(DiskLruCache $this) {
        return $this.initialized;
    }

    public static final /* synthetic */ boolean access$getClosed$p(DiskLruCache $this) {
        return $this.closed;
    }

    public static final /* synthetic */ void access$trimToSize(DiskLruCache $this) {
        $this.trimToSize();
    }

    public static final /* synthetic */ void access$setMostRecentTrimFailed$p(DiskLruCache $this, boolean bl) {
        $this.mostRecentTrimFailed = bl;
    }

    public static final /* synthetic */ boolean access$journalRebuildRequired(DiskLruCache $this) {
        return $this.journalRebuildRequired();
    }

    public static final /* synthetic */ void access$rebuildJournal(DiskLruCache $this) {
        $this.rebuildJournal();
    }

    public static final /* synthetic */ void access$setRedundantOpCount$p(DiskLruCache $this, int n) {
        $this.redundantOpCount = n;
    }

    public static final /* synthetic */ void access$setMostRecentRebuildFailed$p(DiskLruCache $this, boolean bl) {
        $this.mostRecentRebuildFailed = bl;
    }

    public static final /* synthetic */ void access$setJournalWriter$p(DiskLruCache $this, BufferedSink bufferedSink) {
        $this.journalWriter = bufferedSink;
    }

    static {
        String string = "[a-z0-9_-]{1,120}";
        boolean bl = false;
        LEGAL_KEY_PATTERN = new Regex(string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\b\u0018\u00010\u000eR\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcoil/disk/DiskLruCache$Snapshot;", "Ljava/io/Closeable;", "Lokio/Closeable;", "entry", "Lcoil/disk/DiskLruCache$Entry;", "Lcoil/disk/DiskLruCache;", "(Lcoil/disk/DiskLruCache;Lcoil/disk/DiskLruCache$Entry;)V", "closed", "", "getEntry", "()Lcoil/disk/DiskLruCache$Entry;", "close", "", "closeAndEdit", "Lcoil/disk/DiskLruCache$Editor;", "file", "Ljava/io/File;", "index", "", "coil-base_release"})
    public final class Snapshot
    implements Closeable {
        @NotNull
        private final Entry entry;
        private boolean closed;

        public Snapshot(Entry entry) {
            this.entry = entry;
        }

        @NotNull
        public final Entry getEntry() {
            return this.entry;
        }

        @NotNull
        public final File file(int index) {
            boolean bl = !this.closed;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "snapshot is closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return this.entry.getCleanFiles().get(index).toFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                DiskLruCache diskLruCache = DiskLruCache.this;
                DiskLruCache diskLruCache2 = DiskLruCache.this;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (diskLruCache) {
                    boolean bl3 = false;
                    Entry entry = this.getEntry();
                    int n = entry.getLockingSnapshotCount();
                    entry.setLockingSnapshotCount(n + -1);
                    if (this.getEntry().getLockingSnapshotCount() == 0 && this.getEntry().getZombie()) {
                        diskLruCache2.removeEntry(this.getEntry());
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Editor closeAndEdit() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (diskLruCache) {
                boolean bl3 = false;
                this.close();
                Editor editor = diskLruCache2.edit(this.getEntry().getKey());
                return editor;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\f\u0010\r\u001a\b\u0018\u00010\u000eR\u00020\u0004J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0006\u0010\u0011\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcoil/disk/DiskLruCache$Editor;", "", "entry", "Lcoil/disk/DiskLruCache$Entry;", "Lcoil/disk/DiskLruCache;", "(Lcoil/disk/DiskLruCache;Lcoil/disk/DiskLruCache$Entry;)V", "closed", "", "getEntry", "()Lcoil/disk/DiskLruCache$Entry;", "abort", "", "commit", "commitAndGet", "Lcoil/disk/DiskLruCache$Snapshot;", "complete", "success", "detach", "file", "Ljava/io/File;", "index", "", "coil-base_release"})
    public final class Editor {
        @NotNull
        private final Entry entry;
        private boolean closed;

        public Editor(Entry entry) {
            this.entry = entry;
        }

        @NotNull
        public final Entry getEntry() {
            return this.entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final File file(int index) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (diskLruCache) {
                boolean bl3 = false;
                boolean bl4 = !this.closed;
                boolean bl5 = false;
                boolean bl6 = false;
                if (!bl4) {
                    boolean bl7 = false;
                    String string = "editor is closed";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                File file = this.getEntry().getDirtyFiles().get(index).toFile();
                bl5 = false;
                bl6 = false;
                File $this$file_u24lambda_u2d2_u24lambda_u2d1 = file;
                boolean bl8 = false;
                $this$file_u24lambda_u2d2_u24lambda_u2d1.createNewFile();
                File file2 = file;
                return file2;
            }
        }

        public final void detach() {
            if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                this.entry.setZombie(true);
            }
        }

        public final void commit() {
            this.complete(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Snapshot commitAndGet() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (diskLruCache) {
                boolean bl3 = false;
                this.commit();
                Snapshot snapshot = diskLruCache2.get(this.getEntry().getKey());
                return snapshot;
            }
        }

        public final void abort() {
            this.complete(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void complete(boolean success) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (diskLruCache) {
                boolean bl3 = false;
                boolean bl4 = !this.closed;
                boolean bl5 = false;
                boolean bl6 = false;
                if (!bl4) {
                    boolean bl7 = false;
                    String string = "editor is closed";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                if (Intrinsics.areEqual((Object)this.getEntry().getCurrentEditor(), (Object)this)) {
                    diskLruCache2.completeEdit(this, success);
                }
                this.closed = true;
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030,J\f\u0010-\u001a\b\u0018\u00010.R\u00020\rJ\u000e\u0010/\u001a\u00020*2\u0006\u00100\u001a\u000201R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0018\u00010\fR\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%\u00a8\u00062"}, d2={"Lcoil/disk/DiskLruCache$Entry;", "", "key", "", "(Lcoil/disk/DiskLruCache;Ljava/lang/String;)V", "cleanFiles", "Ljava/util/ArrayList;", "Lokio/Path;", "Lkotlin/collections/ArrayList;", "getCleanFiles", "()Ljava/util/ArrayList;", "currentEditor", "Lcoil/disk/DiskLruCache$Editor;", "Lcoil/disk/DiskLruCache;", "getCurrentEditor", "()Lcoil/disk/DiskLruCache$Editor;", "setCurrentEditor", "(Lcoil/disk/DiskLruCache$Editor;)V", "dirtyFiles", "getDirtyFiles", "getKey", "()Ljava/lang/String;", "lengths", "", "getLengths", "()[J", "lockingSnapshotCount", "", "getLockingSnapshotCount", "()I", "setLockingSnapshotCount", "(I)V", "readable", "", "getReadable", "()Z", "setReadable", "(Z)V", "zombie", "getZombie", "setZombie", "setLengths", "", "strings", "", "snapshot", "Lcoil/disk/DiskLruCache$Snapshot;", "writeLengths", "writer", "Lokio/BufferedSink;", "coil-base_release"})
    public final class Entry {
        @NotNull
        private final String key;
        @NotNull
        private final long[] lengths;
        @NotNull
        private final ArrayList<Path> cleanFiles;
        @NotNull
        private final ArrayList<Path> dirtyFiles;
        private boolean readable;
        private boolean zombie;
        @Nullable
        private Editor currentEditor;
        private int lockingSnapshotCount;

        public Entry(String key) {
            this.key = key;
            this.lengths = new long[DiskLruCache.this.valueCount];
            this.cleanFiles = new ArrayList(DiskLruCache.this.valueCount);
            this.dirtyFiles = new ArrayList(DiskLruCache.this.valueCount);
            StringBuilder fileBuilder = new StringBuilder(this.key).append('.');
            int truncateTo = fileBuilder.length();
            int n = 0;
            int n2 = DiskLruCache.this.valueCount;
            if (n < n2) {
                do {
                    int i = n++;
                    fileBuilder.append(i);
                    Entry entry = this;
                    Collection collection = entry.cleanFiles;
                    Path path = DiskLruCache.this.directory.resolve(fileBuilder.toString());
                    boolean bl = false;
                    collection.add(path);
                    fileBuilder.append(".tmp");
                    entry = this;
                    collection = entry.dirtyFiles;
                    path = DiskLruCache.this.directory.resolve(fileBuilder.toString());
                    bl = false;
                    collection.add(path);
                    fileBuilder.setLength(truncateTo);
                } while (n < n2);
            }
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final long[] getLengths() {
            return this.lengths;
        }

        @NotNull
        public final ArrayList<Path> getCleanFiles() {
            return this.cleanFiles;
        }

        @NotNull
        public final ArrayList<Path> getDirtyFiles() {
            return this.dirtyFiles;
        }

        public final boolean getReadable() {
            return this.readable;
        }

        public final void setReadable(boolean bl) {
            this.readable = bl;
        }

        public final boolean getZombie() {
            return this.zombie;
        }

        public final void setZombie(boolean bl) {
            this.zombie = bl;
        }

        @Nullable
        public final Editor getCurrentEditor() {
            return this.currentEditor;
        }

        public final void setCurrentEditor(@Nullable Editor editor) {
            this.currentEditor = editor;
        }

        public final int getLockingSnapshotCount() {
            return this.lockingSnapshotCount;
        }

        public final void setLockingSnapshotCount(int n) {
            this.lockingSnapshotCount = n;
        }

        public final void setLengths(@NotNull List<String> strings) {
            if (strings.size() != DiskLruCache.this.valueCount) {
                throw new IOException(Intrinsics.stringPlus((String)"unexpected journal line: ", strings));
            }
            try {
                int n = 0;
                int n2 = strings.size() + -1;
                if (n <= n2) {
                    do {
                        int i = n++;
                        String string = strings.get(i);
                        boolean bl = false;
                        this.lengths[i] = Long.parseLong(string);
                    } while (n <= n2);
                }
            }
            catch (NumberFormatException _) {
                throw new IOException(Intrinsics.stringPlus((String)"unexpected journal line: ", strings));
            }
        }

        public final void writeLengths(@NotNull BufferedSink writer) {
            for (long length : this.lengths) {
                int n = 32;
                boolean bl = false;
                writer.writeByte(n).writeDecimalLong(length);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Snapshot snapshot() {
            void $this$forEachIndices$iv;
            if (!this.readable) {
                return null;
            }
            if (this.currentEditor != null || this.zombie) {
                return null;
            }
            Object object = this.cleanFiles;
            DiskLruCache diskLruCache = DiskLruCache.this;
            boolean $i$f$forEachIndices = false;
            int n = 0;
            int n2 = $this$forEachIndices$iv.size() + -1;
            if (n <= n2) {
                do {
                    int i$iv = n++;
                    Path file = (Path)$this$forEachIndices$iv.get(i$iv);
                    boolean bl = false;
                    if (diskLruCache.fileSystem.exists(file)) continue;
                    try {
                        diskLruCache.removeEntry(this);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return null;
                } while (n <= n2);
            }
            object = this;
            int n3 = ((Entry)object).lockingSnapshotCount;
            ((Entry)object).lockingSnapshotCount = n3 + 1;
            return new Snapshot(this);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcoil/disk/DiskLruCache$Companion;", "", "()V", "CLEAN", "", "DIRTY", "JOURNAL_FILE", "JOURNAL_FILE_BACKUP", "JOURNAL_FILE_TEMP", "LEGAL_KEY_PATTERN", "Lkotlin/text/Regex;", "MAGIC", "READ", "REMOVE", "VERSION", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

