/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import coil.ImageLoader;
import coil.decode.BitmapFactoryDecoder;
import coil.decode.DecodeResult;
import coil.decode.DecodeUtils;
import coil.decode.Decoder;
import coil.decode.ExifData;
import coil.decode.ExifUtils;
import coil.decode.ExifUtilsKt;
import coil.decode.ImageSource;
import coil.decode.ResourceMetadata;
import coil.fetch.SourceResult;
import coil.request.Options;
import coil.size.-Sizes;
import coil.size.Dimension;
import coil.size.Size;
import coil.util.-Bitmaps;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.coroutines.sync.Semaphore;
import kotlinx.coroutines.sync.SemaphoreKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0003\u0012\u0013\u0014B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\t\u001a\u00020\n*\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"Lcoil/decode/BitmapFactoryDecoder;", "Lcoil/decode/Decoder;", "source", "Lcoil/decode/ImageSource;", "options", "Lcoil/request/Options;", "parallelismLock", "Lkotlinx/coroutines/sync/Semaphore;", "(Lcoil/decode/ImageSource;Lcoil/request/Options;Lkotlinx/coroutines/sync/Semaphore;)V", "decode", "Lcoil/decode/DecodeResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "configureConfig", "", "Landroid/graphics/BitmapFactory$Options;", "exifData", "Lcoil/decode/ExifData;", "configureScale", "Companion", "ExceptionCatchingSource", "Factory", "coil-base_release"})
public final class BitmapFactoryDecoder
implements Decoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageSource source;
    @NotNull
    private final Options options;
    @NotNull
    private final Semaphore parallelismLock;
    public static final int DEFAULT_MAX_PARALLELISM = 4;

    @JvmOverloads
    public BitmapFactoryDecoder(@NotNull ImageSource source, @NotNull Options options, @NotNull Semaphore parallelismLock) {
        this.source = source;
        this.options = options;
        this.parallelismLock = parallelismLock;
    }

    public /* synthetic */ BitmapFactoryDecoder(ImageSource imageSource, Options options, Semaphore semaphore, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            semaphore = SemaphoreKt.Semaphore$default((int)Integer.MAX_VALUE, (int)0, (int)2, null);
        }
        this(imageSource, options, semaphore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object decode(@NotNull Continuation<? super DecodeResult> var1_1) {
        if (!(var1_1 instanceof decode.1)) ** GOTO lbl-1000
        var7_2 = var1_1;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ BitmapFactoryDecoder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.decode((Continuation<? super DecodeResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withPermit$iv = this.parallelismLock;
                $i$f$withPermit = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withPermit$iv;
                $continuation.label = 1;
                v0 = $this$withPermit$iv.acquire((Continuation)$continuation);
                if (v0 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl29
            }
            case 1: {
                $i$f$withPermit = false;
                $this$withPermit$iv = (Semaphore)$continuation.L$1;
                this = (BitmapFactoryDecoder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 3 sources

                $i$a$-withPermit-BitmapFactoryDecoder$decode$2 = false;
                $continuation.L$0 = $this$withPermit$iv;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v1 = InterruptibleKt.runInterruptible$default(null, (Function0)((Function0)new Function0<DecodeResult>(this){
                    final /* synthetic */ BitmapFactoryDecoder this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final DecodeResult invoke() {
                        return BitmapFactoryDecoder.access$decode(this.this$0, new BitmapFactory.Options());
                    }
                }), (Continuation)$continuation, (int)1, null);
                ** if (v1 != var8_4) goto lbl37
lbl36:
                // 1 sources

                return var8_4;
lbl37:
                // 1 sources

                ** GOTO lbl46
            }
            case 2: {
                $i$f$withPermit = false;
                $i$a$-withPermit-BitmapFactoryDecoder$decode$2 = false;
                $this$withPermit$iv = (Semaphore)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl46:
                    // 2 sources

                    var5_11 = (DecodeResult)v1;
                }
                catch (Throwable var5_12) {
                    throw var5_12;
                }
                finally {
                    $this$withPermit$iv.release();
                }
                return var5_11;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final DecodeResult decode(BitmapFactory.Options $this$decode) {
        void $this$toDrawable$iv$iv;
        void $this$toDrawable$iv;
        Object it4;
        ExceptionCatchingSource safeSource = new ExceptionCatchingSource((Source)this.source.source());
        BufferedSource safeBufferedSource = Okio.buffer((Source)((Source)safeSource));
        $this$decode.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)safeBufferedSource.peek().inputStream(), null, (BitmapFactory.Options)$this$decode);
        Exception exception = safeSource.getException();
        if (exception != null) {
            Exception it2 = exception;
            boolean bl = false;
            throw it2;
        }
        $this$decode.inJustDecodeBounds = false;
        ExifData exifData = ExifUtils.INSTANCE.readData($this$decode.outMimeType, safeBufferedSource);
        Exception exception2 = safeSource.getException();
        if (exception2 != null) {
            Exception it3 = exception2;
            boolean bl = false;
            throw it3;
        }
        $this$decode.inMutable = false;
        if (Build.VERSION.SDK_INT >= 26 && this.options.getColorSpace() != null) {
            $this$decode.inPreferredColorSpace = this.options.getColorSpace();
        }
        $this$decode.inPremultiplied = this.options.getPremultipliedAlpha();
        this.configureConfig($this$decode, exifData);
        this.configureScale($this$decode, exifData);
        Closeable it2 = (Closeable)safeBufferedSource;
        Throwable it3 = null;
        try {
            it4 = (BufferedSource)it2;
            boolean bl = false;
            it4 = BitmapFactory.decodeStream((InputStream)it4.inputStream(), null, (BitmapFactory.Options)$this$decode);
        }
        catch (Throwable it4) {
            it3 = it4;
            throw it4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)it2, (Throwable)it3);
        }
        BufferedSource outBitmap = it4;
        Exception exception3 = safeSource.getException();
        if (exception3 != null) {
            it4 = exception3;
            boolean bl = false;
            throw it4;
        }
        if (outBitmap == null) {
            boolean $i$a$-checkNotNull-BitmapFactoryDecoder$decode$72 = false;
            String $i$a$-checkNotNull-BitmapFactoryDecoder$decode$72 = "BitmapFactory returned a null bitmap. Often this means BitmapFactory could not decode the image data read from the input source (e.g. network, disk, or memory) as it's not encoded as a valid image format.";
            throw new IllegalStateException($i$a$-checkNotNull-BitmapFactoryDecoder$decode$72.toString());
        }
        outBitmap.setDensity(this.options.getContext().getResources().getDisplayMetrics().densityDpi);
        Bitmap bitmap = ExifUtils.INSTANCE.reverseTransformations((Bitmap)outBitmap, exifData);
        it3 = bitmap;
        Context context$iv = this.options.getContext();
        boolean $i$f$toDrawable = false;
        void var10_18 = $this$toDrawable$iv;
        Resources resources$iv$iv = context$iv.getResources();
        boolean $i$f$toDrawable2 = false;
        return new DecodeResult((Drawable)new BitmapDrawable(resources$iv$iv, (Bitmap)$this$toDrawable$iv$iv), $this$decode.inSampleSize > 1 || $this$decode.inScaled);
    }

    private final void configureConfig(BitmapFactory.Options $this$configureConfig, ExifData exifData) {
        Bitmap.Config config = this.options.getConfig();
        if (exifData.isFlipped() || ExifUtilsKt.isRotated(exifData)) {
            config = -Bitmaps.toSoftware(config);
        }
        if (this.options.getAllowRgb565() && config == Bitmap.Config.ARGB_8888 && Intrinsics.areEqual((Object)$this$configureConfig.outMimeType, (Object)"image/jpeg")) {
            config = Bitmap.Config.RGB_565;
        }
        if (Build.VERSION.SDK_INT >= 26 && $this$configureConfig.outConfig == Bitmap.Config.RGBA_F16 && config != Bitmap.Config.HARDWARE) {
            config = Bitmap.Config.RGBA_F16;
        }
        $this$configureConfig.inPreferredConfig = config;
    }

    private final void configureScale(BitmapFactory.Options $this$configureScale, ExifData exifData) {
        int n;
        int n2;
        ImageSource.Metadata metadata = this.source.getMetadata();
        if (metadata instanceof ResourceMetadata && -Sizes.isOriginal(this.options.getSize())) {
            $this$configureScale.inSampleSize = 1;
            $this$configureScale.inScaled = true;
            $this$configureScale.inDensity = ((ResourceMetadata)metadata).getDensity();
            $this$configureScale.inTargetDensity = this.options.getContext().getResources().getDisplayMetrics().densityDpi;
            return;
        }
        if ($this$configureScale.outWidth <= 0 || $this$configureScale.outHeight <= 0) {
            $this$configureScale.inSampleSize = 1;
            $this$configureScale.inScaled = false;
            return;
        }
        int srcWidth = ExifUtilsKt.isSwapped(exifData) ? $this$configureScale.outHeight : $this$configureScale.outWidth;
        int srcHeight = ExifUtilsKt.isSwapped(exifData) ? $this$configureScale.outWidth : $this$configureScale.outHeight;
        Size dstSize = this.options.getSize();
        Dimension $this$pxOrElse$iv = dstSize.getWidth();
        boolean $i$f$pxOrElse = false;
        if ($this$pxOrElse$iv instanceof Dimension.Pixels) {
            n2 = ((Dimension.Pixels)$this$pxOrElse$iv).px;
        } else {
            boolean bl = false;
            n2 = srcWidth;
        }
        int dstWidth = n2;
        Dimension $this$pxOrElse$iv2 = dstSize.getHeight();
        boolean $i$f$pxOrElse2 = false;
        if ($this$pxOrElse$iv2 instanceof Dimension.Pixels) {
            n = ((Dimension.Pixels)$this$pxOrElse$iv2).px;
        } else {
            boolean bl = false;
            n = srcHeight;
        }
        int dstHeight = n;
        $this$configureScale.inSampleSize = DecodeUtils.calculateInSampleSize(srcWidth, srcHeight, dstWidth, dstHeight, this.options.getScale());
        double scale = DecodeUtils.computeSizeMultiplier((double)srcWidth / (double)$this$configureScale.inSampleSize, (double)srcHeight / (double)$this$configureScale.inSampleSize, (double)dstWidth, (double)dstHeight, this.options.getScale());
        if (this.options.getAllowInexactSize()) {
            scale = RangesKt.coerceAtMost((double)scale, (double)1.0);
        }
        boolean bl = $this$configureScale.inScaled = !(scale == 1.0);
        if ($this$configureScale.inScaled) {
            if (scale > 1.0) {
                $this$configureScale.inDensity = MathKt.roundToInt((double)((double)Integer.MAX_VALUE / scale));
                $this$configureScale.inTargetDensity = Integer.MAX_VALUE;
            } else {
                $this$configureScale.inDensity = Integer.MAX_VALUE;
                $this$configureScale.inTargetDensity = MathKt.roundToInt((double)((double)Integer.MAX_VALUE * scale));
            }
        }
    }

    @JvmOverloads
    public BitmapFactoryDecoder(@NotNull ImageSource source, @NotNull Options options) {
        this(source, options, null, 4, null);
    }

    public static final /* synthetic */ DecodeResult access$decode(BitmapFactoryDecoder $this, BitmapFactory.Options $receiver) {
        return $this.decode($receiver);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcoil/decode/BitmapFactoryDecoder$Factory;", "Lcoil/decode/Decoder$Factory;", "maxParallelism", "", "(I)V", "parallelismLock", "Lkotlinx/coroutines/sync/Semaphore;", "create", "Lcoil/decode/Decoder;", "result", "Lcoil/fetch/SourceResult;", "options", "Lcoil/request/Options;", "imageLoader", "Lcoil/ImageLoader;", "equals", "", "other", "", "hashCode", "coil-base_release"})
    public static final class Factory
    implements Decoder.Factory {
        @NotNull
        private final Semaphore parallelismLock;

        @JvmOverloads
        public Factory(int maxParallelism) {
            this.parallelismLock = SemaphoreKt.Semaphore$default((int)maxParallelism, (int)0, (int)2, null);
        }

        public /* synthetic */ Factory(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 4;
            }
            this(n);
        }

        @Override
        @NotNull
        public Decoder create(@NotNull SourceResult result2, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            return new BitmapFactoryDecoder(result2.getSource(), options, this.parallelismLock);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof Factory;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        @JvmOverloads
        public Factory() {
            this(0, 1, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016R.\u0010\b\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u00072\u000e\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcoil/decode/BitmapFactoryDecoder$ExceptionCatchingSource;", "Lokio/ForwardingSource;", "delegate", "Lokio/Source;", "(Lokio/Source;)V", "<set-?>", "Ljava/lang/Exception;", "Lkotlin/Exception;", "exception", "getException", "()Ljava/lang/Exception;", "read", "", "sink", "Lokio/Buffer;", "byteCount", "coil-base_release"})
    private static final class ExceptionCatchingSource
    extends ForwardingSource {
        @Nullable
        private Exception exception;

        public ExceptionCatchingSource(@NotNull Source delegate) {
            super(delegate);
        }

        @Nullable
        public final Exception getException() {
            return this.exception;
        }

        public long read(@NotNull Buffer sink, long byteCount) {
            try {
                return super.read(sink, byteCount);
            }
            catch (Exception e) {
                this.exception = e;
                throw e;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/decode/BitmapFactoryDecoder$Companion;", "", "()V", "DEFAULT_MAX_PARALLELISM", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

