/*
 * Decompiled with CFR 0.152.
 */
package coil.util;

import android.os.SystemClock;
import androidx.annotation.WorkerThread;
import coil.util.Logger;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcoil/util/FileDescriptorCounter;", "", "()V", "FILE_DESCRIPTOR_CHECK_INTERVAL_DECODES", "", "FILE_DESCRIPTOR_CHECK_INTERVAL_MILLIS", "FILE_DESCRIPTOR_LIMIT", "TAG", "", "decodesSinceLastFileDescriptorCheck", "fileDescriptorList", "Ljava/io/File;", "hasAvailableFileDescriptors", "", "lastFileDescriptorCheckTimestamp", "", "checkFileDescriptors", "logger", "Lcoil/util/Logger;", "coil-base_release"})
final class FileDescriptorCounter {
    @NotNull
    public static final FileDescriptorCounter INSTANCE = new FileDescriptorCounter();
    @NotNull
    private static final String TAG = "FileDescriptorCounter";
    private static final int FILE_DESCRIPTOR_LIMIT = 800;
    private static final int FILE_DESCRIPTOR_CHECK_INTERVAL_DECODES = 30;
    private static final int FILE_DESCRIPTOR_CHECK_INTERVAL_MILLIS = 30000;
    @NotNull
    private static final File fileDescriptorList = new File("/proc/self/fd");
    private static int decodesSinceLastFileDescriptorCheck = 30;
    private static long lastFileDescriptorCheckTimestamp = SystemClock.uptimeMillis();
    private static boolean hasAvailableFileDescriptors = true;

    private FileDescriptorCounter() {
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public final synchronized boolean hasAvailableFileDescriptors(@Nullable Logger logger) {
        if (this.checkFileDescriptors()) {
            String[] stringArray;
            decodesSinceLastFileDescriptorCheck = 0;
            lastFileDescriptorCheckTimestamp = SystemClock.uptimeMillis();
            String[] $this$orEmpty$iv = fileDescriptorList.list();
            boolean $i$f$orEmpty2 = false;
            Object object = $this$orEmpty$iv;
            if (object == null) {
                boolean $i$f$emptyArray = false;
                stringArray = new String[]{};
            } else {
                stringArray = object;
            }
            int numUsedFileDescriptors = stringArray.length;
            boolean bl = hasAvailableFileDescriptors = numUsedFileDescriptors < 800;
            if (!hasAvailableFileDescriptors) {
                Logger logger2 = logger;
                if (logger2 != null) {
                    void $this$log$iv;
                    Logger $i$f$orEmpty2 = logger2;
                    object = TAG;
                    int priority$iv = 5;
                    boolean $i$f$log = false;
                    if ($this$log$iv.getLevel() <= priority$iv) {
                        void tag$iv;
                        int n = priority$iv;
                        void var10_10 = tag$iv;
                        void var9_11 = $this$log$iv;
                        boolean bl2 = false;
                        String string = Intrinsics.stringPlus((String)"Unable to allocate more hardware bitmaps. Number of used file descriptors: ", (Object)numUsedFileDescriptors);
                        var9_11.log((String)var10_10, n, string, null);
                    }
                }
            }
        }
        return hasAvailableFileDescriptors;
    }

    private final boolean checkFileDescriptors() {
        int n = decodesSinceLastFileDescriptorCheck;
        decodesSinceLastFileDescriptorCheck = n + 1;
        return n >= 30 || SystemClock.uptimeMillis() > lastFileDescriptorCheckTimestamp + (long)30000;
    }
}

