/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import android.graphics.Bitmap;
import androidx.annotation.VisibleForTesting;
import coil.memory.MemoryCache;
import coil.memory.WeakMemoryCache;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0000\u0018\u0000 (2\u00020\u0001:\u0002'(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J4\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u001e\u001a\u00020\rH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\b\u0010!\u001a\u00020\u0017H\u0016J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\rH\u0016J\b\u0010$\u001a\u00020\u0017H\u0002J\r\u0010%\u001a\u00020\u0017H\u0001\u00a2\u0006\u0002\b&R.\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00058\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0003\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u000e\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006)"}, d2={"Lcoil/memory/RealWeakMemoryCache;", "Lcoil/memory/WeakMemoryCache;", "<init>", "()V", "cache", "Ljava/util/LinkedHashMap;", "Lcoil/memory/MemoryCache$Key;", "Ljava/util/ArrayList;", "Lcoil/memory/RealWeakMemoryCache$InternalValue;", "getCache$coil_base_release$annotations", "getCache$coil_base_release", "()Ljava/util/LinkedHashMap;", "operationsSinceCleanUp", "", "keys", "", "Lkotlin/jvm/internal/EnhancedNullability;", "getKeys", "()Ljava/util/Set;", "get", "Lcoil/memory/MemoryCache$Value;", "key", "set", "", "bitmap", "Landroid/graphics/Bitmap;", "extras", "", "", "", "size", "remove", "", "clearMemory", "trimMemory", "level", "cleanUpIfNecessary", "cleanUp", "cleanUp$coil_base_release", "InternalValue", "Companion", "coil-base_release"})
@SourceDebugExtension(value={"SMAP\nWeakMemoryCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WeakMemoryCache.kt\ncoil/memory/RealWeakMemoryCache\n+ 2 Collections.kt\ncoil/util/-Collections\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 Utils.kt\ncoil/util/-Utils\n*L\n1#1,158:1\n44#2,2:159\n47#2:163\n55#2,9:172\n1#3:161\n1#3:162\n381#4,7:164\n162#5:171\n*S KotlinDebug\n*F\n+ 1 WeakMemoryCache.kt\ncoil/memory/RealWeakMemoryCache\n*L\n63#1:159,2\n63#1:163\n137#1:172,9\n63#1:162\n73#1:164,7\n77#1:171\n*E\n"})
public final class RealWeakMemoryCache
implements WeakMemoryCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedHashMap<MemoryCache.Key, ArrayList<InternalValue>> cache = new LinkedHashMap();
    private int operationsSinceCleanUp;
    private static final int CLEAN_UP_INTERVAL = 10;

    @NotNull
    public final LinkedHashMap<MemoryCache.Key, ArrayList<InternalValue>> getCache$coil_base_release() {
        return this.cache;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCache$coil_base_release$annotations() {
    }

    @Override
    @NotNull
    public synchronized Set<MemoryCache.Key> getKeys() {
        return CollectionsKt.toSet((Iterable)this.cache.keySet());
    }

    @Override
    @Nullable
    public synchronized MemoryCache.Value get(@NotNull MemoryCache.Key key) {
        MemoryCache.Value value;
        block4: {
            ArrayList<InternalValue> arrayList = this.cache.get(key);
            if (arrayList == null) {
                return null;
            }
            ArrayList<InternalValue> values = arrayList;
            List $this$firstNotNullOfOrNullIndices$iv = values;
            boolean $i$f$firstNotNullOfOrNullIndices = false;
            int n = ((Collection)$this$firstNotNullOfOrNullIndices$iv).size();
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                MemoryCache.Value value2;
                InternalValue value3 = (InternalValue)$this$firstNotNullOfOrNullIndices$iv.get(i$iv);
                boolean bl = false;
                if ((Bitmap)value3.getBitmap().get() != null) {
                    Bitmap it;
                    boolean bl2 = false;
                    value2 = new MemoryCache.Value(it, value3.getExtras());
                } else {
                    value2 = null;
                }
                if (value2 == null) continue;
                MemoryCache.Value it$iv = value2;
                boolean bl3 = false;
                value = it$iv;
                break block4;
            }
            value = null;
        }
        MemoryCache.Value value4 = value;
        this.cleanUpIfNecessary();
        return value4;
    }

    @Override
    public synchronized void set(@NotNull MemoryCache.Key key, @NotNull Bitmap bitmap, @NotNull Map<String, ? extends Object> extras, int size2) {
        block5: {
            Object object;
            Map $this$getOrPut$iv = this.cache;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key);
            if (value$iv == null) {
                boolean bl = false;
                ArrayList answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ArrayList values = (ArrayList)object;
            RealWeakMemoryCache $this$set_u24lambda_u243 = this;
            boolean bl = false;
            Bitmap $this$identityHashCode$iv = bitmap;
            boolean $i$f$getIdentityHashCode = false;
            int identityHashCode = System.identityHashCode($this$identityHashCode$iv);
            InternalValue newValue = new InternalValue(identityHashCode, new WeakReference<Bitmap>(bitmap), extras, size2);
            int n = ((Collection)values).size();
            for (int index = 0; index < n; ++index) {
                InternalValue value = (InternalValue)values.get(index);
                if (size2 < value.getSize()) continue;
                if (value.getIdentityHashCode() == identityHashCode && value.getBitmap().get() == bitmap) {
                    values.set(index, newValue);
                } else {
                    values.add(index, newValue);
                }
                break block5;
            }
            ((Collection)values).add(newValue);
        }
        this.cleanUpIfNecessary();
    }

    @Override
    public synchronized boolean remove(@NotNull MemoryCache.Key key) {
        return this.cache.remove(key) != null;
    }

    @Override
    public synchronized void clearMemory() {
        this.operationsSinceCleanUp = 0;
        this.cache.clear();
    }

    @Override
    public synchronized void trimMemory(int level) {
        if (level >= 10 && level != 20) {
            this.cleanUp$coil_base_release();
        }
    }

    private final void cleanUpIfNecessary() {
        int n = this.operationsSinceCleanUp;
        this.operationsSinceCleanUp = n + 1;
        if (n >= 10) {
            this.cleanUp$coil_base_release();
        }
    }

    @VisibleForTesting
    public final void cleanUp$coil_base_release() {
        this.operationsSinceCleanUp = 0;
        Iterator<ArrayList<InternalValue>> iterator = this.cache.values().iterator();
        while (iterator.hasNext()) {
            ArrayList<InternalValue> list = iterator.next();
            if (((Collection)list).size() <= 1) {
                Object object = (InternalValue)CollectionsKt.firstOrNull((List)list);
                if ((object != null && (object = ((InternalValue)object).getBitmap()) != null ? (Bitmap)((Reference)object).get() : null) != null) continue;
                iterator.remove();
                continue;
            }
            List $this$removeIfIndices$iv = list;
            boolean $i$f$removeIfIndices = false;
            int numDeleted$iv = 0;
            int n = ((Collection)$this$removeIfIndices$iv).size();
            for (int rawIndex$iv = 0; rawIndex$iv < n; ++rawIndex$iv) {
                int index$iv = rawIndex$iv - numDeleted$iv;
                InternalValue it = (InternalValue)$this$removeIfIndices$iv.get(index$iv);
                boolean bl = false;
                if (!(it.getBitmap().get() == null)) continue;
                $this$removeIfIndices$iv.remove(index$iv);
                ++numDeleted$iv;
            }
            if (!list.isEmpty()) continue;
            iterator.remove();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcoil/memory/RealWeakMemoryCache$Companion;", "", "<init>", "()V", "CLEAN_UP_INTERVAL", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0001\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcoil/memory/RealWeakMemoryCache$InternalValue;", "", "identityHashCode", "", "bitmap", "Ljava/lang/ref/WeakReference;", "Landroid/graphics/Bitmap;", "extras", "", "", "size", "<init>", "(ILjava/lang/ref/WeakReference;Ljava/util/Map;I)V", "getIdentityHashCode", "()I", "getBitmap", "()Ljava/lang/ref/WeakReference;", "getExtras", "()Ljava/util/Map;", "getSize", "coil-base_release"})
    @VisibleForTesting
    public static final class InternalValue {
        private final int identityHashCode;
        @NotNull
        private final WeakReference<Bitmap> bitmap;
        @NotNull
        private final Map<String, Object> extras;
        private final int size;

        public InternalValue(int identityHashCode, @NotNull WeakReference<Bitmap> bitmap, @NotNull Map<String, ? extends Object> extras, int size2) {
            this.identityHashCode = identityHashCode;
            this.bitmap = bitmap;
            this.extras = extras;
            this.size = size2;
        }

        public final int getIdentityHashCode() {
            return this.identityHashCode;
        }

        @NotNull
        public final WeakReference<Bitmap> getBitmap() {
            return this.bitmap;
        }

        @NotNull
        public final Map<String, Object> getExtras() {
            return this.extras;
        }

        public final int getSize() {
            return this.size;
        }
    }
}

