/*
 * Decompiled with CFR 0.152.
 */
package coil.drawable;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Movie;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.SystemClock;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import coil.bitmappool.BitmapPool;
import coil.decode.DecodeUtils;
import coil.size.Scale;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00019B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020!H\u0016J\b\u0010(\u001a\u00020\u001aH\u0016J\b\u0010)\u001a\u00020\u001aH\u0016J\b\u0010*\u001a\u00020\u001aH\u0016J\u0006\u0010+\u001a\u00020\u001aJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020\u0010H\u0014J\u0010\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020\u000eH\u0016J\u0010\u00100\u001a\u00020%2\u0006\u00101\u001a\u00020\u001aH\u0016J\u0012\u00102\u001a\u00020%2\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u000e\u00105\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u001aJ\b\u00106\u001a\u00020%H\u0016J\b\u00107\u001a\u00020%H\u0016J\u0010\u00108\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u000eH\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcoil/drawable/MovieDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat;", "movie", "Landroid/graphics/Movie;", "config", "Landroid/graphics/Bitmap$Config;", "scale", "Lcoil/size/Scale;", "pool", "Lcoil/bitmappool/BitmapPool;", "(Landroid/graphics/Movie;Landroid/graphics/Bitmap$Config;Lcoil/size/Scale;Lcoil/bitmappool/BitmapPool;)V", "callbacks", "", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat$AnimationCallback;", "currentBounds", "Landroid/graphics/Rect;", "frameTimeMillis", "", "hardwareDx", "", "hardwareDy", "hardwareScale", "isRunning", "", "loopIteration", "", "paint", "Landroid/graphics/Paint;", "repeatCount", "softwareBitmap", "Landroid/graphics/Bitmap;", "softwareCanvas", "Landroid/graphics/Canvas;", "softwareScale", "startTimeMillis", "clearAnimationCallbacks", "", "draw", "canvas", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "getRepeatCount", "onBoundsChange", "bounds", "registerAnimationCallback", "callback", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "setRepeatCount", "start", "stop", "unregisterAnimationCallback", "Companion", "coil-gif_release"})
public final class MovieDrawable
extends Drawable
implements Animatable2Compat {
    private final Paint paint;
    private final List<Animatable2Compat.AnimationCallback> callbacks;
    private Rect currentBounds;
    private Canvas softwareCanvas;
    private Bitmap softwareBitmap;
    private float softwareScale;
    private float hardwareScale;
    private float hardwareDx;
    private float hardwareDy;
    private boolean isRunning;
    private long startTimeMillis;
    private long frameTimeMillis;
    private int repeatCount;
    private int loopIteration;
    private final Movie movie;
    private final Bitmap.Config config;
    private final Scale scale;
    private final BitmapPool pool;
    public static final int REPEAT_INFINITE = -1;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NotNull Canvas canvas) {
        Canvas $this$withSave;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Canvas canvas2 = this.softwareCanvas;
        if (canvas2 == null) {
            return;
        }
        Canvas softwareCanvas = canvas2;
        Bitmap bitmap = this.softwareBitmap;
        if (bitmap == null) {
            return;
        }
        Bitmap softwareBitmap = bitmap;
        boolean invalidate = false;
        int time = 0;
        int duration = this.movie.duration();
        if (duration == 0) {
            invalidate = false;
            time = 0;
        } else {
            if (this.isRunning) {
                this.frameTimeMillis = SystemClock.uptimeMillis();
            }
            int elapsedTime = (int)(this.frameTimeMillis - this.startTimeMillis);
            this.loopIteration = elapsedTime / duration;
            invalidate = this.repeatCount == -1 || this.loopIteration <= this.repeatCount;
            time = invalidate ? elapsedTime - this.loopIteration * duration : duration;
        }
        this.movie.setTime(time);
        softwareCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        Canvas $this$withSave$iv = softwareCanvas;
        boolean $i$f$withSave = false;
        int checkpoint$iv = $this$withSave$iv.save();
        try {
            $this$withSave = $this$withSave$iv;
            boolean bl = false;
            $this$withSave.scale(this.softwareScale, this.softwareScale);
            this.movie.draw($this$withSave, 0.0f, 0.0f, this.paint);
        }
        finally {
            $this$withSave$iv.restoreToCount(checkpoint$iv);
        }
        $this$withSave$iv = canvas;
        $i$f$withSave = false;
        checkpoint$iv = $this$withSave$iv.save();
        try {
            $this$withSave = $this$withSave$iv;
            boolean bl = false;
            $this$withSave.translate(this.hardwareDx, this.hardwareDy);
            $this$withSave.scale(this.hardwareScale, this.hardwareScale);
            $this$withSave.drawBitmap(softwareBitmap, 0.0f, 0.0f, this.paint);
        }
        finally {
            $this$withSave$iv.restoreToCount(checkpoint$iv);
        }
        if (this.isRunning && invalidate) {
            this.invalidateSelf();
        } else {
            this.stop();
        }
    }

    public final void setRepeatCount(int repeatCount) {
        boolean bl = repeatCount >= -1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid repeatCount: " + repeatCount;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.repeatCount = repeatCount;
    }

    public final int getRepeatCount() {
        return this.repeatCount;
    }

    public void setAlpha(int alpha) {
        int n = alpha;
        n = 0 <= n && 255 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Invalid alpha: " + alpha;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.paint.setAlpha(alpha);
    }

    public int getOpacity() {
        return this.paint.getAlpha() == 255 && this.movie.isOpaque() ? -1 : -3;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        if (Intrinsics.areEqual((Object)this.currentBounds, (Object)bounds)) {
            return;
        }
        this.currentBounds = bounds;
        float boundsWidth = bounds.width();
        float boundsHeight = bounds.height();
        float movieWidth = this.movie.width();
        float movieHeight = this.movie.height();
        if (movieWidth <= 0.0f || movieHeight <= 0.0f) {
            return;
        }
        this.softwareScale = RangesKt.coerceAtMost((float)DecodeUtils.computeSizeMultiplier((float)movieWidth, (float)movieHeight, (float)boundsWidth, (float)boundsHeight, (Scale)this.scale), (float)1.0f);
        float f = this.softwareScale * movieWidth;
        boolean bl = false;
        float bitmapWidth = (float)Math.ceil(f);
        float f2 = this.softwareScale * movieHeight;
        boolean bl2 = false;
        float bitmapHeight = (float)Math.ceil(f2);
        Bitmap bitmap = this.pool.get((int)bitmapWidth, (int)bitmapHeight, this.config);
        Bitmap bitmap2 = this.softwareBitmap;
        if (bitmap2 != null) {
            Bitmap bitmap3 = bitmap2;
            BitmapPool bitmapPool = this.pool;
            boolean bl3 = false;
            boolean bl4 = false;
            Bitmap p1 = bitmap3;
            boolean bl5 = false;
            bitmapPool.put(p1);
        }
        this.softwareBitmap = bitmap;
        this.softwareCanvas = new Canvas(bitmap);
        this.hardwareScale = DecodeUtils.computeSizeMultiplier((float)bitmapWidth, (float)bitmapHeight, (float)boundsWidth, (float)boundsHeight, (Scale)this.scale);
        this.hardwareDx = (boundsWidth - this.hardwareScale * bitmapWidth) / (float)2;
        this.hardwareDy = (boundsHeight - this.hardwareScale * bitmapHeight) / (float)2;
    }

    public int getIntrinsicWidth() {
        return this.movie.width();
    }

    public int getIntrinsicHeight() {
        return this.movie.height();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.loopIteration = 0;
        this.startTimeMillis = SystemClock.uptimeMillis();
        Iterable $this$forEach$iv = this.callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Animatable2Compat.AnimationCallback it = (Animatable2Compat.AnimationCallback)element$iv;
            boolean bl = false;
            it.onAnimationStart((Drawable)this);
        }
        this.invalidateSelf();
    }

    public void stop() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        Iterable $this$forEach$iv = this.callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Animatable2Compat.AnimationCallback it = (Animatable2Compat.AnimationCallback)element$iv;
            boolean bl = false;
            it.onAnimationEnd((Drawable)this);
        }
    }

    public void registerAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        this.callbacks.add(callback);
    }

    public boolean unregisterAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        return this.callbacks.remove(callback);
    }

    public void clearAnimationCallbacks() {
        this.callbacks.clear();
    }

    public MovieDrawable(@NotNull Movie movie, @NotNull Bitmap.Config config, @NotNull Scale scale, @NotNull BitmapPool pool) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)movie, (String)"movie");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)scale, (String)"scale");
        Intrinsics.checkParameterIsNotNull((Object)pool, (String)"pool");
        this.movie = movie;
        this.config = config;
        this.scale = scale;
        this.pool = pool;
        this.paint = new Paint(3);
        MovieDrawable movieDrawable = this;
        boolean bl = false;
        movieDrawable.callbacks = list = (List)new ArrayList();
        this.softwareScale = 1.0f;
        this.hardwareScale = 1.0f;
        this.repeatCount = -1;
        bl = Build.VERSION.SDK_INT < 26 || this.config != Bitmap.Config.HARDWARE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Bitmap config must not be hardware.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/drawable/MovieDrawable$Companion;", "", "()V", "REPEAT_INFINITE", "", "coil-gif_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

