/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import android.graphics.Bitmap;
import android.graphics.Movie;
import android.graphics.drawable.Drawable;
import android.os.Build;
import coil.bitmap.BitmapPool;
import coil.decode.DecodeResult;
import coil.decode.DecodeUtils;
import coil.decode.Decoder;
import coil.decode.InterruptibleSource;
import coil.decode.Options;
import coil.drawable.MovieDrawable;
import coil.request.Gifs;
import coil.size.Size;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lcoil/decode/GifDecoder;", "Lcoil/decode/Decoder;", "()V", "decode", "Lcoil/decode/DecodeResult;", "pool", "Lcoil/bitmap/BitmapPool;", "source", "Lokio/BufferedSource;", "size", "Lcoil/size/Size;", "options", "Lcoil/decode/Options;", "(Lcoil/bitmap/BitmapPool;Lokio/BufferedSource;Lcoil/size/Size;Lcoil/decode/Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handles", "", "mimeType", "", "Companion", "coil-gif_release"})
public final class GifDecoder
implements Decoder {
    @NotNull
    public static final String REPEAT_COUNT_KEY = "coil#repeat_count";
    public static final Companion Companion = new Companion(null);

    public boolean handles(@NotNull BufferedSource source, @Nullable String mimeType) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return DecodeUtils.isGif((BufferedSource)source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object decode(@NotNull BitmapPool pool, @NotNull BufferedSource source, @NotNull Size size, @NotNull Options options, @NotNull Continuation<? super DecodeResult> $completion) {
        boolean $i$f$withInterruptibleSource = false;
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super DecodeResult> uCont$iv$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv$iv), 1);
        cancellable$iv$iv.initCancellability();
        CancellableContinuation continuation$iv = (CancellableContinuation)cancellable$iv$iv;
        boolean bl2 = false;
        try {
            InterruptibleSource interruptibleSource$iv = new InterruptibleSource(continuation$iv, (Source)source);
            try {
                BufferedSource bufferedSource;
                boolean bl3;
                boolean bl4;
                BufferedSource it2;
                Throwable throwable;
                boolean bl5;
                Closeable closeable;
                Continuation continuation = (Continuation)continuation$iv;
                Source interruptibleSource = (Source)interruptibleSource$iv;
                boolean bl6 = false;
                BufferedSource bufferedSource2 = Okio.buffer((Source)interruptibleSource);
                if (Build.VERSION.SDK_INT <= 18) {
                    closeable = (Closeable)bufferedSource2;
                    bl5 = false;
                    boolean bl7 = false;
                    throwable = null;
                    try {
                        it2 = (BufferedSource)closeable;
                        boolean bl8 = false;
                        byte[] byteArray = it2.readByteArray();
                        Movie movie = Movie.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length);
                        bl4 = false;
                        bl3 = false;
                        bl3 = false;
                        boolean bl9 = false;
                        if (movie == null) {
                            boolean bl10 = false;
                            String string = "Required value was null.";
                            throw (Throwable)new IllegalStateException(string.toString());
                        }
                        it2 = movie;
                        bufferedSource = it2;
                    }
                    catch (Throwable it2) {
                        throwable = it2;
                        throw it2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                closeable = (Closeable)bufferedSource2;
                bl5 = false;
                boolean bl11 = false;
                throwable = null;
                try {
                    it2 = (BufferedSource)closeable;
                    boolean bl12 = false;
                    Movie movie = Movie.decodeStream((InputStream)it2.inputStream());
                    boolean bl13 = false;
                    bl4 = false;
                    bl4 = false;
                    bl3 = false;
                    if (movie == null) {
                        boolean bl14 = false;
                        String string = "Required value was null.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    it2 = movie;
                    bufferedSource = it2;
                }
                catch (Throwable it3) {
                    throwable = it3;
                    throw it3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                BufferedSource movie = bufferedSource;
                boolean bl15 = movie.width() > 0 && movie.height() > 0;
                bl5 = false;
                boolean bl16 = false;
                if (!bl15) {
                    boolean bl17 = false;
                    String string = "Failed to decode GIF.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                MovieDrawable drawable = new MovieDrawable((Movie)movie, pool, movie.isOpaque() && options.getAllowRgb565() ? Bitmap.Config.RGB_565 : (Build.VERSION.SDK_INT >= 26 && options.getConfig() == Bitmap.Config.HARDWARE ? Bitmap.Config.ARGB_8888 : options.getConfig()), options.getScale());
                Integer n = Gifs.repeatCount(options.getParameters());
                drawable.setRepeatCount(n != null ? n : -1);
                DecodeResult decodeResult = new DecodeResult((Drawable)drawable, false);
                boolean bl18 = false;
                Result.Companion companion = Result.Companion;
                boolean bl19 = false;
                continuation.resumeWith(Result.constructor-impl((Object)decodeResult));
            }
            finally {
                interruptibleSource$iv.clearInterrupt();
            }
        }
        catch (Exception exception$iv) {
            if (exception$iv instanceof InterruptedException || exception$iv instanceof InterruptedIOException) {
                Throwable throwable = new CancellationException("Blocking call was interrupted due to parent cancellation.").initCause(exception$iv);
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"CancellationException(\"B\u2026n.\").initCause(exception)");
                throw throwable;
            }
            throw (Throwable)exception$iv;
        }
        Object object = cancellable$iv$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/decode/GifDecoder$Companion;", "", "()V", "REPEAT_COUNT_KEY", "", "coil-gif_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

