/*
 * Decompiled with CFR 0.152.
 */
package io.coodoo.framework.listing.control;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ListingConfig {
    private static Logger log = LoggerFactory.getLogger(ListingConfig.class);
    public static int DEFAULT_INDEX = 0;
    public static int DEFAULT_PAGE = 1;
    public static int DEFAULT_LIMIT = 10;
    public static String FILTER_TYPE_DISJUNCTION = "Filter-Type-Disjunction";
    public static int OR_TO_IN_LIMIT = 10;
    public static String OPERATOR_NOT = "!";
    private static String OPERATOR_NOT_WORD_BLANK = "NOT";
    public static String OPERATOR_NOT_WORD = OPERATOR_NOT_WORD_BLANK + " ";
    public static String OPERATOR_OR = "|";
    private static String OPERATOR_OR_WORD_BLANK = "OR";
    public static String OPERATOR_OR_WORD = " " + OPERATOR_OR_WORD_BLANK + " ";
    public static String OPERATOR_NULL = "NULL";
    private static final String listingPropertiesFilename = "coodoo.listing.properties";
    static Properties properties = new Properties();

    public void init(@Observes @Initialized(value=ApplicationScoped.class) Object init) {
        ListingConfig.loadProperties();
    }

    private static void loadProperties() {
        InputStream inputStream = null;
        try {
            inputStream = ListingConfig.class.getClassLoader().getResourceAsStream(listingPropertiesFilename);
            if (inputStream != null) {
                properties.load(inputStream);
                log.info("Reading {}", (Object)listingPropertiesFilename);
                DEFAULT_INDEX = ListingConfig.loadProperty(DEFAULT_INDEX, "coodoo.listing.default.index");
                DEFAULT_PAGE = ListingConfig.loadProperty(DEFAULT_PAGE, "coodoo.listing.default.page");
                DEFAULT_LIMIT = ListingConfig.loadProperty(DEFAULT_LIMIT, "coodoo.listing.default.limit");
                FILTER_TYPE_DISJUNCTION = ListingConfig.loadProperty(FILTER_TYPE_DISJUNCTION, "coodoo.listing.filter.type.disjunction");
                OR_TO_IN_LIMIT = ListingConfig.loadProperty(OR_TO_IN_LIMIT, "coodoo.listing.or.to.in.imit");
                OPERATOR_NOT = ListingConfig.loadProperty(OPERATOR_NOT, "coodoo.listing.operator.not");
                OPERATOR_NOT_WORD_BLANK = ListingConfig.loadProperty(OPERATOR_NOT_WORD_BLANK, "coodoo.listing.operator.not.word");
                OPERATOR_OR = ListingConfig.loadProperty(OPERATOR_OR, "coodoo.listing.operator_or");
                OPERATOR_OR_WORD_BLANK = ListingConfig.loadProperty(OPERATOR_OR_WORD_BLANK, "coodoo.listing.operator.or.word");
                OPERATOR_NULL = ListingConfig.loadProperty(OPERATOR_NULL, "coodoo.listing.operator.null");
            }
        }
        catch (IOException e) {
            log.info("Couldn't read {}!", (Object)listingPropertiesFilename, (Object)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.warn("Couldn't close {}!", (Object)listingPropertiesFilename, (Object)e);
            }
        }
    }

    private static String loadProperty(String value, String key) {
        String property = properties.getProperty(key);
        if (property == null) {
            return value;
        }
        log.info("Listing Property {} loaded: {}", (Object)key, (Object)property);
        return property;
    }

    private static int loadProperty(int value, String key) {
        String property = properties.getProperty(key);
        if (property != null) {
            try {
                log.info("Listing Property {} loaded: {}", (Object)key, (Object)property);
                return Integer.valueOf(property);
            }
            catch (NumberFormatException e) {
                log.warn("Listing Property {} value invalid: {}", (Object)key, (Object)property);
            }
        }
        return value;
    }
}

