/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.connector.sqlserver.SourceInfo;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerValueConverters;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.HistorizedRelationalDatabaseSchema;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.TableChanges;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerDatabaseSchema
extends HistorizedRelationalDatabaseSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerDatabaseSchema.class);
    private final Set<TableId> capturedTables;

    public SqlServerDatabaseSchema(SqlServerConnectorConfig connectorConfig, SchemaNameAdjuster schemaNameAdjuster, TopicSelector<TableId> topicSelector, SqlServerConnection connection) {
        super((HistorizedRelationalDatabaseConnectorConfig)connectorConfig, topicSelector, connectorConfig.getTableFilters().dataCollectionFilter(), null, new TableSchemaBuilder((ValueConverterProvider)new SqlServerValueConverters(), schemaNameAdjuster, SourceInfo.SCHEMA), false);
        try {
            this.capturedTables = SqlServerDatabaseSchema.determineCapturedTables(connectorConfig, connection);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not obtain the list of captured tables", e);
        }
    }

    public void applySchemaChange(SchemaChangeEvent schemaChange) {
        LOGGER.debug("Applying schema change event {}", (Object)schemaChange);
        Table table = (Table)schemaChange.getTables().iterator().next();
        this.buildAndRegisterSchema(table);
        this.tables().overwriteTable(table);
        TableChanges tableChanges = null;
        if (schemaChange.getType() == SchemaChangeEvent.SchemaChangeEventType.CREATE && schemaChange.isFromSnapshot()) {
            tableChanges = new TableChanges();
            tableChanges.create(table);
        }
        this.record(schemaChange, tableChanges);
    }

    public Set<TableId> getCapturedTables() {
        return this.capturedTables;
    }

    private static Set<TableId> determineCapturedTables(SqlServerConnectorConfig connectorConfig, SqlServerConnection connection) throws SQLException {
        Set allTableIds = connection.readTableNames(connectorConfig.getDatabaseName(), null, null, new String[]{"TABLE"});
        HashSet<TableId> capturedTables = new HashSet<TableId>();
        for (TableId tableId : allTableIds) {
            if (connectorConfig.getTableFilters().dataCollectionFilter().isIncluded(tableId)) {
                capturedTables.add(tableId);
                continue;
            }
            LOGGER.trace("Skipping table {} as it's not included in the filter configuration", (Object)tableId);
        }
        return capturedTables;
    }

    protected DdlParser getDdlParser() {
        return null;
    }
}

