/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import io.dropwizard.auth.Auth;
import io.dropwizard.auth.OptionalPrincipalContainerRequestValueFactory;
import io.dropwizard.auth.PrincipalContainerRequestValueFactory;
import java.lang.reflect.ParameterizedType;
import java.security.Principal;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

@Singleton
public class PolymorphicAuthValueFactoryProvider<T extends Principal>
extends AbstractValueFactoryProvider {
    protected final Set<Class<? extends T>> principalClassSet;

    @Inject
    public PolymorphicAuthValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator injector, PrincipalClassSetProvider<T> principalClassSetProvider) {
        super(mpep, injector, new Parameter.Source[]{Parameter.Source.UNKNOWN});
        this.principalClassSet = ((PrincipalClassSetProvider)principalClassSetProvider).clazzSet;
    }

    @Nullable
    public AbstractContainerRequestValueFactory<?> createValueFactory(Parameter parameter) {
        if (!parameter.isAnnotationPresent(Auth.class)) {
            return null;
        }
        if (this.principalClassSet.contains(parameter.getRawType())) {
            return new PrincipalContainerRequestValueFactory();
        }
        boolean isOptionalPrincipal = parameter.getRawType() == Optional.class && ParameterizedType.class.isAssignableFrom(parameter.getType().getClass()) && this.principalClassSet.contains(((ParameterizedType)parameter.getType()).getActualTypeArguments()[0]);
        return isOptionalPrincipal ? new OptionalPrincipalContainerRequestValueFactory() : null;
    }

    public static class Binder<T extends Principal>
    extends AbstractBinder {
        private final Set<Class<? extends T>> principalClassSet;

        public Binder(Set<Class<? extends T>> principalClassSet) {
            this.principalClassSet = principalClassSet;
        }

        protected void configure() {
            this.bind(new PrincipalClassSetProvider<T>(this.principalClassSet)).to(PrincipalClassSetProvider.class);
            this.bind(PolymorphicAuthValueFactoryProvider.class).to(ValueFactoryProvider.class).in(Singleton.class);
            this.bind(AuthInjectionResolver.class).to((TypeLiteral)new TypeLiteral<InjectionResolver<Auth>>(){}).in(Singleton.class);
        }
    }

    @Singleton
    protected static class PrincipalClassSetProvider<T extends Principal> {
        private final Set<Class<? extends T>> clazzSet;

        public PrincipalClassSetProvider(Set<Class<? extends T>> clazzSet) {
            this.clazzSet = clazzSet;
        }
    }

    @Singleton
    static class AuthInjectionResolver
    extends ParamInjectionResolver<Auth> {
        public AuthInjectionResolver() {
            super(PolymorphicAuthValueFactoryProvider.class);
        }
    }
}

