/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.core;

import com.codahale.metrics.Counter;
import io.engineblock.activityapi.core.Activity;
import io.engineblock.activityapi.core.ActivityDefObserver;
import io.engineblock.activityapi.core.AsyncAction;
import io.engineblock.activityapi.core.Stoppable;
import io.engineblock.activityapi.core.ops.OpContext;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.activityimpl.ParameterMap;
import io.engineblock.metrics.ActivityMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAsyncAction<T extends OpContext, A extends Activity>
implements AsyncAction<T>,
Stoppable,
ActivityDefObserver {
    private static final Logger logger = LoggerFactory.getLogger((String)"BaseAsyncAction");
    protected final A activity;
    public Counter pendingOpsCounter;
    protected int slot;
    protected boolean running = true;
    private int pendingOpsQueuedForThread = 0;
    private int maxOpsQueuedForThread = 1;

    public BaseAsyncAction(A activity, int slot) {
        this.activity = activity;
        this.slot = slot;
        this.onActivityDefUpdate(activity.getActivityDef());
    }

    @Override
    public void onActivityDefUpdate(ActivityDef activityDef) {
        ParameterMap params = activityDef.getParams();
        params.getOptionalInteger("async").orElseThrow(() -> new RuntimeException("the async parameter is required to activate async actions"));
        this.maxOpsQueuedForThread = this.getMaxPendingOps(activityDef);
        this.pendingOpsCounter = ActivityMetrics.counter(activityDef, "pending_ops");
    }

    protected int getMaxPendingOps(ActivityDef def) {
        int maxTotalOpsInFlight = def.getParams().getOptionalInteger("async").orElse(1);
        int threads = def.getThreads();
        return maxTotalOpsInFlight / threads + (this.slot < maxTotalOpsInFlight % threads ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enqueue(T opc) {
        BaseAsyncAction baseAsyncAction = this;
        synchronized (baseAsyncAction) {
            while (this.available() == 0) {
                try {
                    logger.trace("Blocking for enqueue with (" + this.pendingOpsQueuedForThread + "/" + this.maxOpsQueuedForThread + ") queued ops");
                    this.wait(60000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.incrementOps();
        this.startOpCycle(opc);
        return this.running && this.available() > 0;
    }

    @Override
    public synchronized boolean awaitCompletion(long timeout) {
        long endAt = System.currentTimeMillis() + timeout;
        while (this.running && this.pending() > 0 && System.currentTimeMillis() < endAt) {
            try {
                long waitfor = Math.max(0L, endAt - System.currentTimeMillis());
                this.wait(waitfor);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.pending() == 0;
    }

    protected int available() {
        return this.maxOpsQueuedForThread - this.pendingOpsQueuedForThread;
    }

    protected int pending() {
        return this.pendingOpsQueuedForThread;
    }

    protected void incrementOps() {
        this.pendingOpsCounter.inc();
        ++this.pendingOpsQueuedForThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementOps() {
        this.pendingOpsCounter.dec();
        --this.pendingOpsQueuedForThread;
        if (this.pendingOpsQueuedForThread == 0 || this.pendingOpsQueuedForThread == this.maxOpsQueuedForThread - 1) {
            BaseAsyncAction baseAsyncAction = this;
            synchronized (baseAsyncAction) {
                this.notifyAll();
            }
        }
    }

    protected abstract T startOpCycle(T var1);

    @Override
    public void requestStop() {
        logger.info(this.toString() + " requested to stop.");
        this.running = false;
    }

    public abstract T newOpContext();
}

