/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl;

import io.engineblock.activityimpl.ParameterMap;
import io.engineblock.util.Unit;
import java.security.InvalidParameterException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityDef {
    public static final String DEFAULT_ALIAS = "ALIAS_UNSET";
    public static final String DEFAULT_ATYPE = "TYPE_UNSET";
    public static final String DEFAULT_CYCLES = "0";
    public static final int DEFAULT_THREADS = 1;
    private static final Logger logger = LoggerFactory.getLogger(ActivityDef.class);
    private static final String FIELD_ALIAS = "alias";
    private static final String FIELD_ATYPE = "type";
    private static final String FIELD_CYCLES = "cycles";
    private static final String FIELD_THREADS = "threads";
    private static String[] field_list = new String[]{"alias", "type", "cycles", "threads"};
    private ParameterMap parameterMap;

    public ActivityDef(ParameterMap parameterMap) {
        this.parameterMap = parameterMap;
    }

    public static Optional<ActivityDef> parseActivityDefOptionally(String namedActivitySpec) {
        try {
            ActivityDef activityDef = ActivityDef.parseActivityDef(namedActivitySpec);
            return Optional.of(activityDef);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static ActivityDef parseActivityDef(String namedActivitySpec) {
        Optional<ParameterMap> activityParameterMap = ParameterMap.parseParams(namedActivitySpec);
        ActivityDef activityDef = new ActivityDef(activityParameterMap.orElseThrow(() -> new RuntimeException("Unable to parse:" + namedActivitySpec)));
        logger.debug("parsed activityDef " + namedActivitySpec + " to-> " + activityDef);
        return activityDef;
    }

    public String toString() {
        return "ActivityDef:" + this.parameterMap.toString();
    }

    public String getAlias() {
        return this.parameterMap.getOptionalString(FIELD_ALIAS).orElse(DEFAULT_ALIAS);
    }

    public String getActivityType() {
        return this.parameterMap.getOptionalString(FIELD_ATYPE).orElse(DEFAULT_ATYPE);
    }

    public long getStartCycle() {
        String cycles = this.parameterMap.getOptionalString(FIELD_CYCLES).orElse(DEFAULT_CYCLES);
        int rangeAt = cycles.indexOf("..");
        String startCycle = rangeAt > 0 ? cycles.substring(0, rangeAt) : DEFAULT_CYCLES;
        return Unit.longCountFor(startCycle).orElseThrow(() -> new RuntimeException("Unable to parse start cycles from " + startCycle));
    }

    public void setStartCycle(long startCycle) {
        this.parameterMap.set(FIELD_CYCLES, "" + startCycle + ".." + this.getEndCycle());
    }

    public void setStartCycle(String startCycle) {
        this.setStartCycle(Unit.longCountFor(startCycle).orElseThrow(() -> new RuntimeException("Unable to convert start cycle '" + startCycle + "' to a value.")));
    }

    public void setEndCycle(String endCycle) {
        this.setEndCycle(Unit.longCountFor(endCycle).orElseThrow(() -> new RuntimeException("Unable to convert end cycle '" + endCycle + "' to a value.")));
    }

    public long getEndCycle() {
        String cycles = this.parameterMap.getOptionalString(FIELD_CYCLES).orElse(DEFAULT_CYCLES);
        int rangeAt = cycles.indexOf("..");
        String endCycle = rangeAt > 0 ? cycles.substring(rangeAt + 2) : cycles;
        return Unit.longCountFor(endCycle).orElseThrow(() -> new RuntimeException("Unable to convert end cycle from " + endCycle));
    }

    public void setEndCycle(long endCycle) {
        this.parameterMap.set(FIELD_CYCLES, "" + this.getStartCycle() + ".." + endCycle);
    }

    public int getThreads() {
        return this.parameterMap.getOptionalInteger(FIELD_THREADS).orElse(1);
    }

    public void setThreads(int threads) {
        this.parameterMap.set(FIELD_THREADS, threads);
    }

    public ParameterMap getParams() {
        return this.parameterMap;
    }

    public AtomicLong getChangeCounter() {
        return this.parameterMap.getChangeCounter();
    }

    public void setCycles(String cycles) {
        this.parameterMap.set(FIELD_CYCLES, cycles);
        this.checkInvariants();
    }

    public String getCycleSummary() {
        return "[" + this.getStartCycle() + ".." + this.getEndCycle() + ")=" + this.getCycleCount();
    }

    public long getCycleCount() {
        return this.getEndCycle() - this.getStartCycle();
    }

    private void checkInvariants() {
        if (this.getStartCycle() >= this.getEndCycle()) {
            throw new InvalidParameterException("Start cycle must be strictly less than end cycle, but they are [" + this.getStartCycle() + "," + this.getEndCycle() + ")");
        }
    }
}

