/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl.motor;

import com.codahale.metrics.Timer;
import io.engineblock.activityapi.core.Action;
import io.engineblock.activityapi.core.Activity;
import io.engineblock.activityapi.core.ActivityDefObserver;
import io.engineblock.activityapi.core.AsyncAction;
import io.engineblock.activityapi.core.Motor;
import io.engineblock.activityapi.core.MultiPhaseAction;
import io.engineblock.activityapi.core.RunState;
import io.engineblock.activityapi.core.Startable;
import io.engineblock.activityapi.core.Stoppable;
import io.engineblock.activityapi.core.SyncAction;
import io.engineblock.activityapi.core.ops.OpContext;
import io.engineblock.activityapi.core.ops.OpResultBuffer;
import io.engineblock.activityapi.cyclelog.buffers.results.CycleResultSegmentBuffer;
import io.engineblock.activityapi.cyclelog.buffers.results.CycleResultsSegment;
import io.engineblock.activityapi.cyclelog.buffers.results.CycleSegment;
import io.engineblock.activityapi.input.Input;
import io.engineblock.activityapi.output.Output;
import io.engineblock.activityapi.rates.RateLimiter;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.activityimpl.SlotStateTracker;
import io.engineblock.metrics.ActivityMetrics;
import java.util.ArrayDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreMotor
implements ActivityDefObserver,
Motor,
Stoppable {
    private static final Logger logger = LoggerFactory.getLogger(CoreMotor.class);
    Timer cyclesTimer;
    Timer phasesTimer;
    Timer stridesTimer;
    Timer inputTimer;
    private long slotId;
    private Input input;
    private Action action;
    private Activity activity;
    private SlotStateTracker slotStateTracker;
    private AtomicReference<RunState> slotState;
    private int stride = 1;
    private Output output;
    private RateLimiter strideRateLimiter;
    private RateLimiter cycleRateLimiter;
    private RateLimiter phaseRateLimiter;
    private ArrayDeque<OpContext> contextPool = new ArrayDeque();

    public CoreMotor(Activity activity, long slotId, Input input) {
        this.activity = activity;
        this.slotId = slotId;
        this.setInput(input);
        this.slotStateTracker = new SlotStateTracker(slotId);
        this.slotState = this.slotStateTracker.getAtomicSlotState();
        this.onActivityDefUpdate(activity.getActivityDef());
    }

    public CoreMotor(Activity activity, long slotId, Input input, Action action) {
        this(activity, slotId, input);
        this.setAction(action);
    }

    public CoreMotor(Activity activity, long slotId, Input input, Action action, Output output) {
        this(activity, slotId, input);
        this.setAction(action);
        this.setResultOutput(output);
    }

    @Override
    public Motor setInput(Input input) {
        this.input = input;
        return this;
    }

    @Override
    public Input getInput() {
        return this.input;
    }

    @Override
    public Motor setAction(Action action) {
        this.action = action;
        return this;
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public long getSlotId() {
        return this.slotId;
    }

    @Override
    public SlotStateTracker getSlotStateTracker() {
        return this.slotStateTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block67: {
            try {
                this.cyclesTimer = ActivityMetrics.timer(this.activity.getActivityDef(), "cycles");
                this.phasesTimer = ActivityMetrics.timer(this.activity.getActivityDef(), "phases");
                this.stridesTimer = ActivityMetrics.timer(this.activity.getActivityDef(), "strides");
                this.inputTimer = ActivityMetrics.timer(this.activity.getActivityDef(), "read_input");
                this.strideRateLimiter = this.activity.getStrideLimiter();
                this.cycleRateLimiter = this.activity.getCycleLimiter();
                this.phaseRateLimiter = this.activity.getPhaseLimiter();
                if (this.slotState.get() == RunState.Finished) {
                    logger.warn("Input was already exhausted for slot " + this.slotId + ", remaining in finished state.");
                }
                this.slotStateTracker.enterState(RunState.Running);
                MultiPhaseAction multiPhaseAction = null;
                if (this.action instanceof MultiPhaseAction) {
                    multiPhaseAction = (MultiPhaseAction)this.action;
                }
                this.action.init();
                if (this.input instanceof Startable) {
                    ((Startable)((Object)this.input)).start();
                }
                if (this.strideRateLimiter != null) {
                    this.strideRateLimiter.start();
                }
                long strideDelay = 0L;
                long cycleDelay = 0L;
                long phaseDelay = 0L;
                if (this.action instanceof AsyncAction) {
                    AsyncAction async = (AsyncAction)AsyncAction.class.cast(this.action);
                    while (this.slotState.get() == RunState.Running) {
                        CycleSegment cycleSegment = null;
                        try (Timer.Context inputTime = this.inputTimer.time();){
                            cycleSegment = this.input.getInputSegment(this.stride);
                        }
                        if (cycleSegment == null) {
                            logger.debug("input exhausted (input " + this.input + ") via null segment, stopping motor thread " + this.slotId);
                            this.slotStateTracker.enterState(RunState.Finished);
                            continue;
                        }
                        if (this.strideRateLimiter != null) {
                            strideDelay = this.strideRateLimiter.acquire();
                        }
                        StrideTracker strideTracker = new StrideTracker(this.stridesTimer, this.cyclesTimer, strideDelay, cycleSegment.peekNextCycle(), this.stride, this.output).start();
                        long strideStart = System.nanoTime();
                        while (!cycleSegment.isExhausted() && this.slotState.get() == RunState.Running) {
                            long cyclenum = cycleSegment.nextCycle();
                            if (cyclenum < 0L && cycleSegment.isExhausted()) {
                                logger.trace("input exhausted (input " + this.input + ") via negative read, stopping motor thread " + this.slotId);
                                this.slotStateTracker.enterState(RunState.Finished);
                                continue;
                            }
                            if (this.slotState.get() != RunState.Running) {
                                logger.trace("motor stopped in cycle " + cyclenum + ", stopping motor thread " + this.slotId);
                                continue;
                            }
                            if (this.cycleRateLimiter != null) {
                                cycleDelay = this.cycleRateLimiter.acquire();
                            }
                            try {
                                OpContext opc = async.newOpContext().addSink(strideTracker);
                                opc.setWaitTime(cycleDelay).setCycle(cyclenum);
                                async.enqueue(opc);
                            }
                            catch (Exception t) {
                                logger.error("Error while processing async cycle " + cyclenum + ", error:" + t);
                                throw t;
                            }
                        }
                    }
                    if (this.slotState.get() == RunState.Finished) {
                        boolean finished = async.awaitCompletion(60000L);
                        if (finished) {
                            logger.debug("slot " + this.slotId + " completed successfully");
                        } else {
                            logger.warn("slot " + this.slotId + " was stopped before completing successfully");
                        }
                    }
                    if (this.slotState.get() == RunState.Stopping) {
                        this.slotStateTracker.enterState(RunState.Stopped);
                    }
                    break block67;
                }
                if (this.action instanceof SyncAction) {
                    if (this.activity.getActivityDef().getParams().containsKey("async")) {
                        throw new RuntimeException("The async parameter was given for this activity, but it does not seem to know how to do async.");
                    }
                    SyncAction sync = (SyncAction)this.action;
                    while (this.slotState.get() == RunState.Running) {
                        CycleSegment cycleSegment = null;
                        CycleResultSegmentBuffer segBuffer = new CycleResultSegmentBuffer(this.stride);
                        try (Timer.Context inputTime = this.inputTimer.time();){
                            cycleSegment = this.input.getInputSegment(this.stride);
                        }
                        if (cycleSegment == null) {
                            logger.debug("input exhausted (input " + this.input + ") via null segment, stopping motor thread " + this.slotId);
                            this.slotStateTracker.enterState(RunState.Finished);
                            continue;
                        }
                        if (this.strideRateLimiter != null) {
                            strideDelay = this.strideRateLimiter.acquire();
                        }
                        long strideStart = System.nanoTime();
                        try {
                            while (!cycleSegment.isExhausted()) {
                                long cyclenum = cycleSegment.nextCycle();
                                if (cyclenum < 0L && cycleSegment.isExhausted()) {
                                    logger.trace("input exhausted (input " + this.input + ") via negative read, stopping motor thread " + this.slotId);
                                    this.slotStateTracker.enterState(RunState.Finished);
                                    continue;
                                }
                                if (this.slotState.get() != RunState.Running) {
                                    logger.trace("motor stopped after input (input " + cyclenum + "), stopping motor thread " + this.slotId);
                                    continue;
                                }
                                int result = -1;
                                if (this.cycleRateLimiter != null) {
                                    cycleDelay = this.cycleRateLimiter.acquire();
                                }
                                long cycleStart = System.nanoTime();
                                try {
                                    logger.trace("cycle " + cyclenum);
                                    long phaseStart = System.nanoTime();
                                    if (this.phaseRateLimiter != null) {
                                        phaseDelay = this.phaseRateLimiter.acquire();
                                    }
                                    result = sync.runCycle(cyclenum);
                                    long phaseEnd = System.nanoTime();
                                    this.phasesTimer.update(phaseEnd - phaseStart + phaseDelay, TimeUnit.NANOSECONDS);
                                    if (multiPhaseAction != null) {
                                        while (multiPhaseAction.incomplete()) {
                                            phaseStart = System.nanoTime();
                                            if (this.phaseRateLimiter != null) {
                                                phaseDelay = this.phaseRateLimiter.acquire();
                                            }
                                            result = multiPhaseAction.runPhase(cyclenum);
                                            phaseEnd = System.nanoTime();
                                            this.phasesTimer.update(phaseEnd - phaseStart + phaseDelay, TimeUnit.NANOSECONDS);
                                        }
                                    }
                                }
                                finally {
                                    long cycleEnd = System.nanoTime();
                                    this.cyclesTimer.update(cycleEnd - cycleStart + cycleDelay, TimeUnit.NANOSECONDS);
                                }
                                segBuffer.append(cyclenum, result);
                            }
                        }
                        finally {
                            long strideEnd = System.nanoTime();
                            this.stridesTimer.update(strideEnd - strideStart + strideDelay, TimeUnit.NANOSECONDS);
                        }
                        if (this.output == null) continue;
                        CycleResultsSegment outputBuffer = segBuffer.toReader();
                        try {
                            this.output.onCycleResultSegment(outputBuffer);
                        }
                        catch (Exception t) {
                            logger.error("Error while feeding result segment " + outputBuffer + " to output '" + this.output + "', error:" + t);
                            throw t;
                        }
                    }
                    if (this.slotState.get() == RunState.Stopping) {
                        this.slotStateTracker.enterState(RunState.Stopped);
                    }
                    break block67;
                }
                throw new RuntimeException("Valid Action implementations must implement either the SyncAction or the AsyncAction sub-interface");
            }
            catch (Throwable t) {
                logger.error("Error in core motor loop:" + t, t);
                throw t;
            }
        }
    }

    public String toString() {
        return "slot:" + this.slotId + "; state:" + (Object)((Object)this.slotState.get());
    }

    @Override
    public void onActivityDefUpdate(ActivityDef activityDef) {
        for (Object component : new Object[]{this.input, this.action, this.output}) {
            if (!(component instanceof ActivityDefObserver)) continue;
            ((ActivityDefObserver)component).onActivityDefUpdate(activityDef);
        }
        this.stride = activityDef.getParams().getOptionalInteger("stride").orElse(1);
    }

    @Override
    public synchronized void requestStop() {
        if (this.slotState.get() == RunState.Running) {
            if (this.input instanceof Stoppable) {
                ((Stoppable)((Object)this.input)).requestStop();
            }
            if (this.action instanceof Stoppable) {
                ((Stoppable)((Object)this.action)).requestStop();
            }
            this.slotStateTracker.enterState(RunState.Stopping);
        } else if (this.slotState.get() != RunState.Stopped && this.slotState.get() != RunState.Stopping) {
            logger.warn("attempted to stop motor " + this.getSlotId() + ": from non Running state:" + (Object)((Object)this.slotState.get()));
        }
    }

    public void setResultOutput(Output resultOutput) {
        this.output = resultOutput;
    }

    public static class StrideTracker
    extends OpResultBuffer {
        private final Timer strideTimer;
        private final Timer cycleTimer;
        private final Output output;

        public StrideTracker(Timer strideTimer, Timer cycleTimer, long strideDelay, long initialCycle, int size, Output output) {
            super(initialCycle, strideDelay, OpContext[].class, size);
            this.strideTimer = strideTimer;
            this.cycleTimer = cycleTimer;
            this.output = output;
        }

        public StrideTracker start() {
            this.getContext().start();
            return this;
        }

        @Override
        public void onAfterOpStop(OpContext opc) {
            this.cycleTimer.update(opc.getFinalResponseTime(), TimeUnit.NANOSECONDS);
            super.onAfterOpStop(opc);
        }

        @Override
        public void onFull() {
            this.getContext().stop(0);
            this.strideTimer.update(this.getContext().getFinalResponseTime(), TimeUnit.NANOSECONDS);
            logger.trace("completed stride with first result cycle (" + this.getContext().getCycle() + ")");
            if (this.output != null) {
                try {
                    this.flip();
                    int remaining = this.remaining();
                    for (int i = 0; i < remaining; ++i) {
                        OpContext opc = (OpContext)this.get();
                        this.output.onCycleResult(opc);
                    }
                }
                catch (Exception t) {
                    logger.error("Error while feeding cycle result to output '" + this.output + "', error:" + t);
                    throw t;
                }
            }
        }
    }
}

