/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi;

import io.engineblock.activityapi.ActionDispenser;
import io.engineblock.activityapi.ActivitiesAware;
import io.engineblock.activityapi.Activity;
import io.engineblock.activityapi.MotorDispenser;
import io.engineblock.activityapi.cycletracking.filters.IntPredicateDispenser;
import io.engineblock.activityapi.input.InputDispenser;
import io.engineblock.activityapi.output.OutputDispenser;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.activityimpl.CoreServices;
import io.engineblock.activityimpl.SimpleActivity;
import io.engineblock.activityimpl.action.CoreActionDispenser;
import io.engineblock.activityimpl.motor.CoreMotorDispenser;
import io.engineblock.util.Named;
import io.engineblock.util.SimpleServiceLoader;
import java.util.Map;
import java.util.Optional;

public interface ActivityType<A extends Activity>
extends Named {
    public static final SimpleServiceLoader<ActivityType> FINDER = new SimpleServiceLoader<ActivityType>(ActivityType.class);

    @Override
    public String getName();

    default public A getActivity(ActivityDef activityDef) {
        SimpleActivity activity = new SimpleActivity(activityDef);
        return (A)activity;
    }

    default public Activity getAssembledActivity(ActivityDef activityDef, Map<String, Activity> activities) {
        A activity = this.getActivity(activityDef);
        InputDispenser inputDispenser = this.getInputDispenser(activity);
        if (inputDispenser instanceof ActivitiesAware) {
            ((ActivitiesAware)((Object)inputDispenser)).setActivitiesMap(activities);
        }
        activity.setInputDispenserDelegate(inputDispenser);
        ActionDispenser actionDispenser = this.getActionDispenser(activity);
        if (actionDispenser instanceof ActivitiesAware) {
            ((ActivitiesAware)((Object)actionDispenser)).setActivitiesMap(activities);
        }
        activity.setActionDispenserDelegate(actionDispenser);
        IntPredicateDispenser resultFilterDispenser = this.getResultFilterDispenser(activity).orElse(null);
        if (resultFilterDispenser != null && resultFilterDispenser instanceof ActivitiesAware) {
            ((ActivitiesAware)((Object)actionDispenser)).setActivitiesMap(activities);
        }
        activity.setResultFilterDispenserDelegate(resultFilterDispenser);
        OutputDispenser outputDispenser = this.getMarkerDispenser(activity).orElse(null);
        if (outputDispenser != null && outputDispenser instanceof ActivitiesAware) {
            ((ActivitiesAware)((Object)outputDispenser)).setActivitiesMap(activities);
        }
        activity.setMarkerDispenserDelegate(outputDispenser);
        MotorDispenser motorDispenser = this.getMotorDispenser(activity, inputDispenser, actionDispenser, outputDispenser, resultFilterDispenser);
        if (motorDispenser instanceof ActivitiesAware) {
            ((ActivitiesAware)((Object)motorDispenser)).setActivitiesMap(activities);
        }
        activity.setMotorDispenserDelegate(motorDispenser);
        return activity;
    }

    default public Optional<IntPredicateDispenser> getResultFilterDispenser(A activity) {
        return CoreServices.getResultFilterDispenser(activity);
    }

    default public Optional<OutputDispenser> getMarkerDispenser(A activity) {
        return CoreServices.getOutputDispenser(activity);
    }

    default public ActionDispenser getActionDispenser(A activity) {
        return new CoreActionDispenser((Activity)activity);
    }

    default public InputDispenser getInputDispenser(A activity) {
        return CoreServices.getInputDispenser(activity);
    }

    default public MotorDispenser getMotorDispenser(A activity, InputDispenser inputDispenser, ActionDispenser actionDispenser, OutputDispenser outputDispenser, IntPredicateDispenser outputFilterDispenser) {
        return new CoreMotorDispenser((Activity)activity, inputDispenser, actionDispenser, outputDispenser, outputFilterDispenser);
    }
}

