/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cycletracking.buffers.results_rle;

import io.engineblock.activityapi.cycletracking.buffers.CycleResultSegmentsReadable;
import io.engineblock.activityapi.cycletracking.buffers.results.CycleResult;
import io.engineblock.activityapi.cycletracking.buffers.results.CycleResultsSegment;
import io.engineblock.activityapi.cycletracking.buffers.results_rle.CycleSpanResults;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class CycleResultsRLEBufferReadable
implements CycleResultSegmentsReadable {
    public static final int BYTES = 17;
    private final ByteBuffer buf;
    private Iterator<CycleResult> it;

    public CycleResultsRLEBufferReadable(ByteBuffer buf) {
        this.buf = buf;
    }

    public CycleResultsRLEBufferReadable(int readsize, ByteBuffer src) {
        readsize = readsize / 17 * 17;
        int bufsize = Math.min(readsize, src.remaining());
        byte[] bbuf = new byte[bufsize];
        src.get(bbuf);
        this.buf = ByteBuffer.wrap(bbuf);
    }

    public static CycleResultsRLEBufferReadable forOneRleSpan(ByteBuffer src) {
        if (src.remaining() >= 17) {
            byte[] segbuf = new byte[17];
            src.get(segbuf);
            return new CycleResultsRLEBufferReadable(ByteBuffer.wrap(segbuf));
        }
        return null;
    }

    @Override
    @NotNull
    public Iterator<CycleResultsSegment> iterator() {
        return new SegmentIterator(this.buf.duplicate());
    }

    private class BasicCycleResult
    implements CycleResult {
        private final int result;
        private final long cycle;

        private BasicCycleResult(long cycle, int result) {
            this.result = result;
            this.cycle = cycle;
        }

        @Override
        public long getCycle() {
            return this.cycle;
        }

        @Override
        public int getResult() {
            return this.result;
        }
    }

    private static class SegmentIterator
    implements Iterator<CycleResultsSegment> {
        private ByteBuffer sibuf;

        private SegmentIterator(ByteBuffer sibuf) {
            this.sibuf = sibuf;
        }

        @Override
        public boolean hasNext() {
            return this.sibuf.remaining() > 0;
        }

        @Override
        public CycleResultsSegment next() {
            if (this.sibuf.remaining() <= 0) {
                return null;
            }
            long min = this.sibuf.getLong();
            long nextMin = this.sibuf.getLong();
            byte result = this.sibuf.get();
            return new CycleSpanResults(min, nextMin, result);
        }
    }
}

