/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cycletracking.buffers.results_rle;

import io.engineblock.activityapi.cycletracking.buffers.results.CycleResult;
import io.engineblock.activityapi.cycletracking.buffers.results.CycleResultsSegment;
import io.engineblock.activityapi.cycletracking.outputs.SimpleCycleResult;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class CycleSpanResults
implements CycleResultsSegment {
    private final long min;
    private final long nextMin;
    private final int result;

    public CycleSpanResults(long min, long nextMin, int result) {
        this.min = min;
        this.nextMin = nextMin;
        this.result = result;
    }

    @Override
    public long getCount() {
        return (long)((int)this.nextMin) - this.min;
    }

    @Override
    public long getMinCycle() {
        return this.min;
    }

    public String toString() {
        return "[" + this.min + "," + this.nextMin + ")->" + this.result;
    }

    @Override
    @NotNull
    public Iterator<CycleResult> iterator() {
        return new Iter(this.min, this.nextMin);
    }

    private class Iter
    implements Iterator<CycleResult> {
        private final long nextMin;
        private long next;

        public Iter(long min, long nextMin) {
            this.next = min;
            this.nextMin = nextMin;
        }

        @Override
        public boolean hasNext() {
            return this.next < this.nextMin;
        }

        @Override
        public CycleResult next() {
            return new SimpleCycleResult(this.next++, CycleSpanResults.this.result);
        }
    }
}

