/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cycletracking.filters;

import io.engineblock.activityapi.cycletracking.filters.ResultFilterType;
import io.engineblock.util.SimpleConfig;
import java.util.Arrays;
import java.util.function.IntPredicate;

public class IncludeCodesType
implements ResultFilterType {
    @Override
    public String getName() {
        return "include";
    }

    @Override
    public IntPredicate getIntPredicate(SimpleConfig conf) {
        return new IncludeCodes(conf);
    }

    private static class IncludeCodes
    implements IntPredicate {
        private final int[] lut;

        public IncludeCodes(SimpleConfig conf) {
            this.lut = this.parseCodes(128, conf.getString("codes").orElseThrow(() -> new RuntimeException("codes= was not provided in the int predicate config for " + this.toString())));
        }

        private int[] parseCodes(int len, String codes) {
            int[] values;
            int[] lut = new int[len];
            for (int value : values = Arrays.stream(codes.split(";")).mapToInt(Integer::valueOf).toArray()) {
                if (value < 0 || value > 127) {
                    throw new RuntimeException("this filter only allows values in [0..127] for now.");
                }
                lut[value] = 1;
            }
            return lut;
        }

        @Override
        public boolean test(int value) {
            if (value < 0) {
                return false;
            }
            return this.lut[value] > 0;
        }
    }
}

