/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cycletracking.inputs.cyclelog;

import io.engineblock.activityapi.Activity;
import io.engineblock.activityapi.cycletracking.buffers.cycles.CycleSegment;
import io.engineblock.activityapi.cycletracking.buffers.cycles.CycleSegmentBuffer;
import io.engineblock.activityapi.cycletracking.buffers.results.CycleResult;
import io.engineblock.activityapi.cycletracking.buffers.results.CycleResultStrider;
import io.engineblock.activityapi.cycletracking.buffers.results.CycleResultsSegment;
import io.engineblock.activityapi.cycletracking.buffers.results_rle.CycleResultsRLEBufferReadable;
import io.engineblock.activityapi.input.SegmentedInput;
import io.engineblock.util.SimpleConfig;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CycleLogReader
implements SegmentedInput,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(CycleLogReader.class);
    private RandomAccessFile raf;
    private MappedByteBuffer mbb;
    private Activity activity;
    CycleResultsRLEBufferReadable currentBuffer;
    CycleResultStrider strider;

    public CycleLogReader(Activity activity) {
        this.activity = activity;
        SimpleConfig conf = new SimpleConfig(activity, "input");
        this.mbb = this.initMappedBuffer(conf.getString("file").orElse(activity.getAlias() + "-input") + ".cyclelog");
        activity.registerAutoCloseable(this);
    }

    private MappedByteBuffer initMappedBuffer(String filename) {
        File filepath = new File(filename);
        if (!filepath.exists()) {
            throw new RuntimeException("file path '" + filename + "' does not exist!");
        }
        try {
            this.raf = new RandomAccessFile(filepath, "rw");
            this.mbb = this.raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.raf.length());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.mbb;
    }

    @Override
    public synchronized CycleSegment getInputSegment(int segmentLength) {
        CycleSegmentBuffer csb = new CycleSegmentBuffer(segmentLength);
        int remaining = csb.remaining();
        while (remaining > 0) {
            CycleResultsSegment cycleResultsSegment;
            if (this.currentBuffer == null) {
                this.currentBuffer = CycleResultsRLEBufferReadable.forOneRleSpan(this.mbb);
                if (this.currentBuffer == null) {
                    return null;
                }
                this.strider = new CycleResultStrider(this.currentBuffer.getCycleResultIterable().iterator());
            }
            if ((cycleResultsSegment = this.strider.getCycleResultsSegment(remaining)) != null) {
                for (CycleResult cycleResult : cycleResultsSegment) {
                    csb.append(cycleResult.getCycle());
                }
            }
            remaining = csb.remaining();
        }
        return csb.toReadable();
    }

    @Override
    public void close() throws Exception {
        if (this.raf != null) {
            this.raf.close();
            this.mbb = null;
        }
    }
}

