/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cycletracking.outputs.cyclelog;

import io.engineblock.activityapi.Activity;
import io.engineblock.activityapi.OutputType;
import io.engineblock.activityapi.cycletracking.outputs.ReorderingConcurrentResultBuffer;
import io.engineblock.activityapi.cycletracking.outputs.cyclelog.CycleLogOutput;
import io.engineblock.activityapi.input.ContiguousInput;
import io.engineblock.activityapi.input.Input;
import io.engineblock.activityapi.output.Output;
import io.engineblock.activityapi.output.OutputDispenser;
import io.engineblock.activityimpl.marker.ReorderingContiguousOutputChunker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CycleLogOutputType
implements OutputType {
    @Override
    public String getName() {
        return "cyclelog";
    }

    @Override
    public OutputDispenser getMarkerDispenser(Activity activity) {
        return new Dispenser(activity);
    }

    public static class Dispenser
    implements OutputDispenser {
        private static final Logger logger = LoggerFactory.getLogger(OutputDispenser.class);
        private final Output output;
        private Activity activity;

        public Dispenser(Activity activity) {
            this.activity = activity;
            Input input = activity.getInputDispenserDelegate().getInput(0L);
            CycleLogOutput rleFileWriter = new CycleLogOutput(activity);
            if (input instanceof ContiguousInput) {
                logger.debug("pre-buffering output extents contiguously before RLE buffering");
                ReorderingContiguousOutputChunker reorderingContiguousOutputChunker = new ReorderingContiguousOutputChunker(activity);
                reorderingContiguousOutputChunker.addExtentReader(rleFileWriter);
                this.output = reorderingContiguousOutputChunker;
            } else {
                logger.debug("pre-buffering output extends with best-effort before RLE buffering");
                ReorderingConcurrentResultBuffer prebuffer = new ReorderingConcurrentResultBuffer(rleFileWriter, 10000, 1000);
                this.output = prebuffer;
            }
            activity.registerAutoCloseable(this.output);
        }

        @Override
        public Output getMarker(long slot) {
            return this.output;
        }
    }
}

