/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cycletracking.outputs.logger;

import io.engineblock.activityapi.output.Output;
import io.engineblock.activityimpl.ActivityDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingOutput
implements Output {
    private static final Logger logger = LoggerFactory.getLogger(LoggingOutput.class);
    private final ActivityDef def;
    private final long slot;
    private final ThreadLocal<StringBuilder> sb = ThreadLocal.withInitial(StringBuilder::new);

    public LoggingOutput(ActivityDef def, long slot) {
        this.def = def;
        this.slot = slot;
    }

    @Override
    public boolean onCycleResult(long completedCycle, int result) {
        this.sb.get().setLength(0);
        this.sb.get().append("activity=").append(this.def.getAlias()).append(",cycle=").append(completedCycle).append(",result=").append((byte)(result & 0x7F));
        logger.info(this.sb.get().toString());
        return true;
    }

    @Override
    public void close() throws Exception {
    }
}

