/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl.input;

import com.codahale.metrics.Gauge;
import com.google.shaded.common.util.concurrent.RateLimiter;
import io.engineblock.activityapi.ActivityDefObserver;
import io.engineblock.activityapi.cycletracking.buffers.cycles.CycleSegment;
import io.engineblock.activityapi.input.ContiguousInput;
import io.engineblock.activityapi.input.RateLimiterProvider;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.activityimpl.input.InputInterval;
import io.engineblock.metrics.ActivityMetrics;
import java.security.InvalidParameterException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetRateInput
implements ContiguousInput,
ActivityDefObserver,
RateLimiterProvider {
    private static final Logger logger = LoggerFactory.getLogger(TargetRateInput.class);
    private final AtomicLong cycleValue = new AtomicLong(0L);
    private final AtomicLong min = new AtomicLong(0L);
    private final AtomicLong max = new AtomicLong(Long.MAX_VALUE);
    private RateLimiter rateLimiter;
    private ActivityDef activityDef;

    public TargetRateInput(ActivityDef activityDef) {
        this.activityDef = activityDef;
        this.onActivityDefUpdate(activityDef);
    }

    @Override
    public CycleSegment getInputSegment(int stride) {
        long next;
        long current;
        do {
            if ((next = (current = this.cycleValue.get()) + (long)stride) <= this.max.get()) continue;
            return null;
        } while (!this.cycleValue.compareAndSet(current, next));
        return new InputInterval.Segment(current, next);
    }

    public String toString() {
        return "TargetRateInput{cycleValue=" + this.cycleValue + ", min=" + this.min + ", max=" + this.max + ", rateLimiter=" + this.rateLimiter + ", activity=" + this.activityDef.getAlias() + '}';
    }

    @Override
    public void onActivityDefUpdate(ActivityDef activityDef) {
        long endCycle;
        long startCycle = activityDef.getStartCycle();
        if (startCycle > (endCycle = activityDef.getEndCycle())) {
            throw new InvalidParameterException("min (" + this.min + ") must be less than or equal to max (" + this.max + ")");
        }
        if (this.max.get() != endCycle) {
            this.max.set(endCycle);
        }
        if (this.min.get() != startCycle) {
            this.min.set(startCycle);
            this.cycleValue.set(this.min.get());
        }
        this.updateRateLimiter(activityDef);
    }

    private void updateRateLimiter(ActivityDef activityDef) {
        double rate = activityDef.getParams().getOptionalDoubleUnitCount("targetrate").orElse(Double.NaN);
        if (!Double.isNaN(rate)) {
            if (this.rateLimiter == null) {
                this.rateLimiter = RateLimiter.create(rate);
            } else {
                this.rateLimiter.setRate(rate);
            }
            Gauge<Double> rateGauge = new Gauge<Double>(){

                @Override
                public Double getValue() {
                    return TargetRateInput.this.rateLimiter.getRate();
                }
            };
            ActivityMetrics.gauge(activityDef, "targetrate", rateGauge);
            logger.info("targetrate was set to:" + rate);
        }
    }

    @Override
    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }
}

