/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.planning;

import io.engineblock.planning.ElementSequencer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;

public class BucketSequencer<T>
implements ElementSequencer<T> {
    private List<T> elems;
    private ToLongFunction<T> ratioFunc;

    @Override
    public int[] sequenceByIndex(List<T> elems, ToLongFunction<T> ratioFunc) {
        List<OpBucket<Object>> buckets = new ArrayList<OpBucket<T>>();
        ArrayList sequence = new ArrayList();
        for (int i2 = 0; i2 < elems.size(); ++i2) {
            T elem = elems.get(i2);
            buckets.add(new OpBucket<T>(elem, i2, ratioFunc.applyAsLong(elem)));
        }
        while (!buckets.isEmpty()) {
            buckets.forEach(b -> sequence.add(b.dispenseRank()));
            buckets = buckets.stream().filter(b -> ((OpBucket)b).count > 0L).collect(Collectors.toCollection(LinkedList::new));
        }
        return sequence.stream().mapToInt(i -> i).toArray();
    }

    private static final class OpBucket<T> {
        private final int rank;
        private T elem;
        private long count;

        OpBucket(T elem, int rank, long ratio) {
            this.elem = elem;
            this.rank = rank;
            this.count = ratio;
        }

        public boolean isEmpty() {
            return this.count == 0L;
        }

        int dispenseRank() {
            --this.count;
            return this.rank;
        }
    }
}

