/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.scripting;

import io.engineblock.scripting.Evaluator;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NashornEvaluator<T>
implements Evaluator<T> {
    private static final Logger logger = LoggerFactory.getLogger(NashornEvaluator.class);
    private static final ScriptEngineManager engineManager = new ScriptEngineManager();
    private final ScriptEngine scriptEngine;
    private final SimpleBindings bindings = new SimpleBindings();
    private String script = "";
    private Class<? extends T> resultType;
    private CompiledScript compiled;

    public NashornEvaluator(Class<? extends T> resultType, Object ... vars) {
        this.scriptEngine = engineManager.getEngineByName("nashorn");
        this.scriptEngine.setBindings(this.bindings, 100);
        this.resultType = resultType;
        for (int i = 0; i < vars.length; i += 2) {
            this.put(vars[i].toString(), vars[i + 1]);
        }
    }

    @Override
    public NashornEvaluator<T> script(String scriptText) {
        this.script = scriptText;
        try {
            Object result = null;
            if (this.scriptEngine instanceof Compilable) {
                logger.info("Using direct script compilation");
                Compilable compilableEngine = (Compilable)((Object)this.scriptEngine);
                this.compiled = compilableEngine.compile(this.script);
                logger.trace("Compiled script:" + this.script);
            } else {
                logger.trace("Did not compile script: " + this.script);
            }
        }
        catch (ScriptException e) {
            String errorDesc = "Script compilation error for " + scriptText + ": " + e.getMessage();
            throw new RuntimeException(errorDesc, e);
        }
        return this;
    }

    @Override
    public T eval() {
        T result = null;
        try {
            Object evaled = null;
            evaled = this.compiled != null ? this.compiled.eval() : this.scriptEngine.eval(this.script);
            result = this.convert(this.resultType, evaled);
        }
        catch (ScriptException e) {
            String errorDesc = "Script error while evaluating result for '" + this.script + "':" + e.getMessage();
            logger.error(errorDesc, e);
            throw new RuntimeException(errorDesc, e);
        }
        catch (Exception o) {
            String errorDesc = "Non-Script error while evaluating result for '" + this.script + "':" + o.getMessage();
            logger.error(errorDesc, o);
            throw new RuntimeException(errorDesc, o);
        }
        return result;
    }

    @Override
    public NashornEvaluator<T> put(String varName, Object var) {
        this.bindings.put(varName, var);
        return this;
    }

    private T convert(Class<? extends T> expectedType, Object result) {
        if (expectedType.isAssignableFrom(result.getClass())) {
            return expectedType.cast(result);
        }
        String desiredClass = expectedType.getSimpleName();
        Class<?> resultClass = result.getClass();
        if (resultClass == Double.class) {
            switch (desiredClass) {
                case "Long": {
                    return expectedType.cast(((Double)result).longValue());
                }
                case "Integer": {
                    return expectedType.cast(((Double)result).intValue());
                }
                case "Float": {
                    return expectedType.cast(Float.valueOf(((Double)result).floatValue()));
                }
            }
            throw new RuntimeException("Incompatible result type requested for conversion from " + resultClass + " to " + desiredClass);
        }
        if (resultClass == Long.class) {
            switch (desiredClass) {
                case "Integer": {
                    return expectedType.cast(((Long)result).intValue());
                }
            }
            throw new RuntimeException("Incompatible result type requested for conversion from " + resultClass + " to " + desiredClass);
        }
        throw new RuntimeException("Incompatible input type for conversion from evaluator:" + result.getClass() + ", when type " + expectedType.getSimpleName() + " was needed.");
    }
}

