/*
 * Decompiled with CFR 0.152.
 */
package activityconfig.yaml;

import activityconfig.MultiMapLookup;
import activityconfig.rawyaml.RawStmtDef;
import activityconfig.rawyaml.RawStmtsBlock;
import activityconfig.yaml.StmtDef;
import activityconfig.yaml.StmtsDoc;
import io.engineblock.util.Tagged;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StmtsBlock
implements Tagged,
Iterable<StmtDef> {
    private static final String NameToken = "name";
    private static final String StmtToken = "stmt";
    private final RawStmtsBlock rawStmtsBlock;
    private StmtsDoc rawStmtsDoc;
    private int blockIdx;

    public StmtsBlock(RawStmtsBlock rawStmtsBlock, StmtsDoc rawStmtsDoc, int blockIdx) {
        this.rawStmtsBlock = rawStmtsBlock;
        this.rawStmtsDoc = rawStmtsDoc;
        this.blockIdx = blockIdx;
    }

    public List<StmtDef> getStmts() {
        ArrayList<StmtDef> rawStmtDefs = new ArrayList<StmtDef>();
        List<RawStmtDef> statements = this.rawStmtsBlock.getRawStmtDefs();
        for (int i = 0; i < statements.size(); ++i) {
            rawStmtDefs.add(new StmtDef(this, statements.get(i)));
        }
        return rawStmtDefs;
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        if (!this.rawStmtsDoc.getName().isEmpty()) {
            sb.append(this.rawStmtsDoc.getName()).append("--");
        }
        if (!this.rawStmtsBlock.getName().isEmpty()) {
            sb.append(this.rawStmtsBlock.getName());
        } else {
            sb.append("block").append(this.blockIdx);
        }
        return sb.toString();
    }

    @Override
    public Map<String, String> getTags() {
        return new MultiMapLookup(this.rawStmtsBlock.getTags(), this.rawStmtsDoc.getTags());
    }

    public Map<String, String> getParams() {
        return new MultiMapLookup(this.rawStmtsBlock.getParams(), this.rawStmtsDoc.getParams());
    }

    public Map<String, String> getBindings() {
        return new MultiMapLookup(this.rawStmtsBlock.getBindings(), this.rawStmtsDoc.getBindings());
    }

    @Override
    public Iterator<StmtDef> iterator() {
        return this.getStmts().iterator();
    }
}

