/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.core;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import io.engineblock.activityapi.core.Activity;
import io.engineblock.activityapi.core.ActivityInstrumentation;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.activityimpl.ParameterMap;
import io.engineblock.metrics.ActivityMetrics;

public class CoreActivityInstrumentation
implements ActivityInstrumentation {
    private static final String STRICTMETRICNAMES = "strictmetricnames";
    private static final String WAIT_TIME = ".waittime";
    private static final String SERVICE_TIME = ".servicetime";
    private static final String RESPONSE_TIME = ".responsetime";
    private final Activity activity;
    private final ActivityDef def;
    private final ParameterMap params;
    private final String svcTimeSuffix;
    private final boolean strictNaming;

    public CoreActivityInstrumentation(Activity activity) {
        this.activity = activity;
        this.def = activity.getActivityDef();
        this.params = this.def.getParams();
        this.strictNaming = this.params.getOptionalBoolean(STRICTMETRICNAMES).orElse(true);
        this.svcTimeSuffix = this.strictNaming ? SERVICE_TIME : "";
    }

    @Override
    public synchronized Timer getOrCreateInputTimer() {
        String metricName = "read_input";
        return ActivityMetrics.timer(this.def, metricName);
    }

    @Override
    public synchronized Timer getOrCreateStridesServiceTimer() {
        return ActivityMetrics.timer(this.def, "strides.servicetime");
    }

    @Override
    public synchronized Timer getStridesResponseTimerOrNull() {
        if (this.activity.getStrideLimiter() == null) {
            return null;
        }
        return ActivityMetrics.timer(this.def, "strides.responsetime");
    }

    @Override
    public synchronized Timer getOrCreateCyclesServiceTimer() {
        return ActivityMetrics.timer(this.def, "cycles" + this.svcTimeSuffix);
    }

    @Override
    public synchronized Timer getCyclesResponseTimerOrNull() {
        if (this.activity.getCycleLimiter() == null) {
            return null;
        }
        String metricName = "cycles.responsetime";
        return ActivityMetrics.timer(this.def, metricName);
    }

    @Override
    public synchronized Timer getOrCreatePhasesServiceTimer() {
        return ActivityMetrics.timer(this.def, "phases.servicetime");
    }

    @Override
    public synchronized Timer getPhasesResponseTimerOrNull() {
        if (this.activity.getPhaseLimiter() == null) {
            return null;
        }
        return ActivityMetrics.timer(this.def, "phases.responsetime");
    }

    @Override
    public synchronized Counter getOrCreatePendingOpCounter() {
        String metricName = "pending_ops";
        return ActivityMetrics.counter(this.def, metricName);
    }
}

