/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.errorhandling;

import io.engineblock.activityapi.errorhandling.CycleErrorHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashedErrorHandler<T extends Throwable, R>
implements CycleErrorHandler<T, R> {
    private static final Logger logger = LoggerFactory.getLogger(HashedErrorHandler.class);
    private final CycleErrorHandler<T, R> DEFAULT_defaultHandler = (cycle, error, errMsg) -> {
        throw new RuntimeException("no handler defined for type " + error.getClass() + " in cycle " + cycle + ", " + errMsg);
    };
    private Class<? extends Throwable> upperBound = Throwable.class;
    private Map<String, Set<Class<? extends T>>> errorGroups = new ConcurrentHashMap<String, Set<Class<? extends T>>>();
    private Map<Class<? extends T>, CycleErrorHandler<T, R>> handlers = new ConcurrentHashMap<Class<? extends T>, CycleErrorHandler<T, R>>();
    private Set<Class<? extends T>> validClasses = new HashSet<Class<? extends T>>();
    private CycleErrorHandler<T, R> defaultHandler = this.DEFAULT_defaultHandler;

    @SafeVarargs
    public final void setGroup(String groupName, Class<? extends T> ... exceptions) {
        this.errorGroups.put(groupName, new HashSet<Class<? extends T>>(Arrays.asList(exceptions)));
        this.addValidClasses(exceptions);
    }

    public Set<Class<? extends T>> getGroup(String groupName) {
        return this.errorGroups.get(groupName);
    }

    @SafeVarargs
    public final synchronized void setHandlerForClasses(CycleErrorHandler<T, R> errorHandler, Class<? extends T> ... errorClasses) {
        for (Class<T> clazz : errorClasses) {
            logger.debug("handling " + clazz.getSimpleName() + " with " + errorHandler);
            this.handlers.put(clazz, errorHandler);
        }
    }

    public final synchronized void setHandlerForGroup(String groupName, CycleErrorHandler<T, R> errorHandler) {
        Set<Class<T>> classes = this.errorGroups.get(groupName);
        if (classes == null) {
            throw new RuntimeException("Group name '" + groupName + "' was not found.");
        }
        for (Class<? extends T> clazz : classes) {
            this.setHandlerForClasses(errorHandler, clazz);
        }
    }

    public final synchronized void setHandlerForPattern(String pattern, CycleErrorHandler<T, R> errorHandler) {
        this.findValidClasses(pattern).forEach(c -> this.setHandlerForClasses(errorHandler, (Class<? extends T>)c));
    }

    public final synchronized void resetAllClassHandlers() {
        this.handlers.clear();
    }

    public final synchronized Map<Class<? extends T>, CycleErrorHandler<T, R>> getHandlers() {
        return Collections.unmodifiableMap(this.handlers);
    }

    @SafeVarargs
    public final synchronized void addValidClasses(Class<? extends T> ... validClasses) {
        this.validClasses.addAll(Arrays.asList(validClasses));
    }

    public Set<Class<? extends T>> getValidClasses() {
        return Collections.unmodifiableSet(this.validClasses);
    }

    public HashedErrorHandler<T, R> setDefaultHandler(CycleErrorHandler<T, R> errorHandler) {
        Objects.requireNonNull(errorHandler);
        this.defaultHandler = errorHandler;
        return this;
    }

    public HashedErrorHandler<T, R> setUpperBound(Class<? extends T> upperBound) {
        this.upperBound = upperBound;
        return this;
    }

    private List<Class<? extends T>> findValidClasses(String partialClassName) {
        boolean requireOne = true;
        Pattern p = null;
        if (partialClassName.matches("^\\w+$")) {
            p = Pattern.compile("^.*" + partialClassName + ".*$");
        } else {
            p = Pattern.compile(partialClassName);
            requireOne = false;
        }
        List<Class<T>> matchedClasses = this.validClasses.stream().filter(cn -> cn.getSimpleName().matches("^.*" + partialClassName + ".*$")).collect(Collectors.toList());
        if (matchedClasses.size() == 0) {
            throw new RuntimeException("Found no matching classes for class name pattern " + partialClassName + ". Valid class names are:\n" + this.validClasses.stream().map(Class::getSimpleName).collect(Collectors.joining("\n", " ", "")));
        }
        if (requireOne && matchedClasses.size() > 1) {
            throw new RuntimeException("Found " + matchedClasses.size() + " matching classes for class name shortcut '" + partialClassName + "':\n" + matchedClasses.stream().map(Class::getSimpleName).collect(Collectors.joining(",")));
        }
        return matchedClasses;
    }

    @Override
    public R handleError(long cycle, T throwable, String errMsg) {
        Class<?> errorClass = throwable.getClass();
        CycleErrorHandler<T, R> errorHandler = null;
        while (errorHandler == null) {
            errorHandler = this.handlers.get(errorClass);
            if (this.upperBound.isAssignableFrom(errorClass = errorClass.getSuperclass())) continue;
        }
        errorHandler = errorHandler == null ? this.defaultHandler : errorHandler;
        return errorHandler.handleError(cycle, throwable, errMsg);
    }

    public List<String> getGroupNames() {
        return new ArrayList<String>(this.errorGroups.keySet());
    }
}

