/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.ratelimits;

import com.codahale.metrics.Timer;
import io.engineblock.activityapi.ratelimits.RateSpec;
import io.engineblock.activityapi.ratelimits.TokenPool;
import io.engineblock.activityapi.sysperf.SysPerf;
import io.engineblock.activityapi.sysperf.SysPerfData;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.metrics.ActivityMetrics;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenFiller
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(TokenFiller.class);
    public static final double MIN_PER_SECOND = 10.0;
    public static final double MAX_PER_SECOND = 1000.0;
    private final SysPerfData PERFDATA = SysPerf.get().getPerfData(false);
    private final long interval = 1000000L;
    private final TokenPool tokenPool;
    private volatile boolean running = true;
    private RateSpec rateSpec;
    private Thread thread;
    private volatile long lastRefillAt;
    private Timer timer;

    public TokenFiller(RateSpec rateSpec, ActivityDef def) {
        this.rateSpec = rateSpec;
        this.tokenPool = new TokenPool(rateSpec);
        this.tokenPool.refill(rateSpec.getNanosPerOp());
        this.timer = ActivityMetrics.timer(def, "tokenfiller");
    }

    public TokenFiller apply(RateSpec rateSpec) {
        this.rateSpec = rateSpec;
        this.tokenPool.apply(rateSpec);
        return this;
    }

    private void stop() {
        this.running = false;
    }

    public TokenPool getTokenPool() {
        return this.tokenPool;
    }

    @Override
    public void run() {
        this.lastRefillAt = System.nanoTime();
        while (this.running) {
            long nextRefillTime = this.lastRefillAt + 1000000L;
            long thisRefillTime = System.nanoTime();
            while (thisRefillTime < nextRefillTime) {
                long parkfor = Math.max(nextRefillTime - thisRefillTime, 0L);
                LockSupport.parkNanos(parkfor);
                thisRefillTime = System.nanoTime();
            }
            long delta = thisRefillTime - this.lastRefillAt;
            this.lastRefillAt = thisRefillTime;
            this.tokenPool.refill(delta);
            this.timer.update(delta, TimeUnit.NANOSECONDS);
        }
    }

    public TokenFiller start() {
        this.thread = new Thread(this);
        this.thread.setName(this.toString());
        this.thread.setPriority(10);
        this.thread.setDaemon(true);
        this.thread.start();
        logger.debug("Starting token filler thread: " + this.toString());
        return this;
    }

    public String toString() {
        return "TokenFiller spec=" + this.rateSpec + " interval=" + this.interval + "ns pool:" + this.tokenPool + " running=" + this.running;
    }

    public synchronized long restart() {
        this.lastRefillAt = System.nanoTime();
        logger.debug("Restarting token filler at " + this.lastRefillAt + " thread: " + this.toString());
        long wait = this.tokenPool.restart();
        return wait;
    }
}

