/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.sysperf;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.openjdk.jmh.results.RunResult;

public class SysPerfData {
    public static final long currentVersion = 1L;
    private static final String METHOD_THREAD_SLEEP = "callThreadSleep";
    private static final String METHOD_SYSTEM_NANOTIME = "callSystemNanoTime";
    private static final String METHOD_LOCKSUPPORT_PARKNANOS = "callLockSupportParkNanos";
    private Map<String, Double> values = new HashMap<String, Double>();
    private long version;

    public SysPerfData() {
    }

    public SysPerfData(Collection<RunResult> results, long version) {
        this.version = version;
        System.out.println(results);
        this.values = results.stream().filter(r -> r.getPrimaryResult().getScoreUnit().equals("ns/op")).collect(Collectors.toMap(r -> r.getPrimaryResult().getLabel(), k -> k.getPrimaryResult().getScore()));
    }

    public Map<String, Double> getValues() {
        return this.values;
    }

    public void setValues(Map<String, Double> values) {
        this.values = values;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public String toString() {
        return String.format("sleep=%.3fns parknanos=%.3fns nanotime=%.3fns", this.getAvgNanos_Thread_Sleep(), this.getAvgNanos_LockSupport_ParkNanos(), this.getAvgNanos_System_NanoTime());
    }

    public double getAvgNanos_LockSupport_ParkNanos() {
        return this.values.get(METHOD_LOCKSUPPORT_PARKNANOS);
    }

    public double getAvgNanos_System_NanoTime() {
        return this.values.get(METHOD_SYSTEM_NANOTIME);
    }

    public double getAvgNanos_Thread_Sleep() {
        return this.values.get(METHOD_THREAD_SLEEP);
    }
}

