/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.util;

import io.engineblock.activityimpl.ActivityDef;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLKsFactory {
    private static final Logger logger = LoggerFactory.getLogger(SSLKsFactory.class);
    private static SSLKsFactory instance = new SSLKsFactory();

    private SSLKsFactory() {
    }

    public static SSLKsFactory get() {
        return instance;
    }

    public ServerSocketFactory createSSLServerSocketFactory(ActivityDef def) {
        return ((SSLContext)this.getContext(def)).getServerSocketFactory();
    }

    public SocketFactory createSocketFactory(ActivityDef def) {
        return ((SSLContext)this.getContext(def)).getSocketFactory();
    }

    public Object getContext(ActivityDef def) {
        Optional<String> sslParam = def.getParams().getOptionalString("ssl");
        if (sslParam.isPresent()) {
            if (sslParam.get().equals("jdk") || sslParam.get().equals("true")) {
                if (sslParam.get().equals("true")) {
                    logger.warn("Please update your 'ssl=true' parameter to 'ssl=jdk'");
                }
                String keystorePath = def.getParams().getOptionalString("keystore").orElse("JKS");
                String keystorePass = def.getParams().getOptionalString("kspass").orElse("NONE");
                String tlsVersion = def.getParams().getOptionalString("tlsversion").orElse("TLSv1.2");
                try {
                    KeyStore ks = KeyStore.getInstance("JKS");
                    ks.load(new FileInputStream(keystorePath), keystorePass.toCharArray());
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    kmf.init(ks, keystorePass.toCharArray());
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ks);
                    SSLContext sc = SSLContext.getInstance(tlsVersion);
                    sc.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                    return sc;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (sslParam.get().equals("openssl")) {
                logger.info("Cluster builder proceeding with SSL and Client Auth");
                String keyPassword = def.getParams().getOptionalString("keyPassword").orElse(null);
                String caCertFileLocation = def.getParams().getOptionalString("caCertFilePath").orElse(null);
                String certFileLocation = def.getParams().getOptionalString("certFilePath").orElse(null);
                String keyFileLocation = def.getParams().getOptionalString("keyFilePath").orElse(null);
                try {
                    KeyStore ks = KeyStore.getInstance("JKS", "SUN");
                    ks.load(null, keyPassword.toCharArray());
                    X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new FileInputStream(caCertFileLocation));
                    ks.setCertificateEntry(cert.getSubjectX500Principal().getName(), cert);
                    TrustManagerFactory tMF = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tMF.init(ks);
                    SslContext sslContext = SslContextBuilder.forClient().trustManager(tMF).keyManager(new File(certFileLocation), new File(keyFileLocation)).build();
                    return sslContext;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException("The 'ssl' parameter must have one of jdk, or openssl");
        }
        return null;
    }
}

