/*
 * Decompiled with CFR 0.152.
 */
package activityconfig.snakecharmer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class SnakeYamlCharmer
extends Constructor {
    private final Map<String, HandlerDef> handlerDefs = new HashMap<String, HandlerDef>();
    private final ReSafeConstructor ctor = new ReSafeConstructor();

    public SnakeYamlCharmer(Class<?> targetClass) {
        super(targetClass);
        this.yamlClassConstructors.put(NodeId.mapping, new DelegatorConstructor());
    }

    public <T> void addHandler(Class<T> typeName, String fieldName, FieldHandler fieldHandler) {
        this.handlerDefs.put(fieldName, new HandlerDef(fieldName, typeName, fieldHandler));
    }

    public static class ReSafeConstructor
    extends SafeConstructor {
        public Object constructObject(Node node) {
            return super.constructObject(node);
        }
    }

    private class DelegatorConstructor
    extends Constructor.ConstructMapping {
        private DelegatorConstructor() {
            super((Constructor)SnakeYamlCharmer.this);
        }

        protected Object constructJavaBean2ndStep(MappingNode node, Object object) {
            if (node.getNodeId() == NodeId.mapping) {
                ArrayList<NodeTuple> toExtract = new ArrayList<NodeTuple>();
                for (NodeTuple nodeTuple : node.getValue()) {
                    Node prospectNode = nodeTuple.getKeyNode();
                    if (!(nodeTuple.getKeyNode() instanceof ScalarNode)) continue;
                    ScalarNode nameNode = (ScalarNode)prospectNode;
                    if (!SnakeYamlCharmer.this.handlerDefs.keySet().contains(nameNode.getValue())) continue;
                    toExtract.add(nodeTuple);
                }
                for (NodeTuple nodeTuple : toExtract) {
                    node.getValue().remove(nodeTuple);
                    String nodeName = ((ScalarNode)nodeTuple.getKeyNode()).getValue();
                    Object subObject = SnakeYamlCharmer.this.ctor.constructObject(nodeTuple.getValueNode());
                    HandlerDef handlerDef = SnakeYamlCharmer.this.handlerDefs.get(nodeName);
                    handlerDef.handler.handleMapping(object, subObject);
                }
            }
            return super.constructJavaBean2ndStep(node, object);
        }
    }

    private static class HandlerDef {
        final String fieldName;
        final Class<?> handlerClass;
        final FieldHandler handler;

        HandlerDef(String fieldName, Class<?> handlerClass, FieldHandler handler) {
            this.fieldName = fieldName;
            this.handlerClass = handlerClass;
            this.handler = handler;
        }
    }

    public static interface FieldHandler {
        public void handleMapping(Object var1, Object var2);
    }
}

