/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.core.ops.fluent.opfacets;

import io.engineblock.activityapi.core.ops.fluent.opfacets.FailedOp;
import io.engineblock.activityapi.core.ops.fluent.opfacets.OpFacets;
import io.engineblock.activityapi.core.ops.fluent.opfacets.SkippedOp;
import io.engineblock.activityapi.core.ops.fluent.opfacets.StartedOp;
import io.engineblock.activityapi.core.ops.fluent.opfacets.SucceededOp;

public class OpImpl<D>
implements OpFacets<D> {
    private D data;
    private long cycle;
    private int cycleResult;
    private long waitTime;
    private long endedAtNanos;
    private long startedAtNanos;
    private int tries = 0;
    private int skipreason;

    @Override
    public StartedOp<D> start() {
        this.endedAtNanos = Long.MIN_VALUE;
        this.startedAtNanos = System.nanoTime();
        this.tries = 1;
        return this;
    }

    @Override
    public OpImpl<D> setWaitTime(long waitTime) {
        this.endedAtNanos = Long.MIN_VALUE;
        this.waitTime = waitTime;
        this.startedAtNanos = System.nanoTime();
        return this;
    }

    @Override
    public SucceededOp<D> succeed(int status) {
        this.endedAtNanos = System.nanoTime();
        this.cycleResult = status;
        return this;
    }

    @Override
    public FailedOp<D> fail(int status) {
        this.endedAtNanos = System.nanoTime();
        this.cycleResult = status;
        return this;
    }

    @Override
    public StartedOp<D> retry() {
        this.startedAtNanos = System.nanoTime();
        this.endedAtNanos = Long.MIN_VALUE;
        ++this.tries;
        return this;
    }

    @Override
    public SkippedOp<D> skip(int reason) {
        this.skipreason = reason;
        return this;
    }

    @Override
    public long getCycle() {
        return this.cycle;
    }

    @Override
    public void setCycle(long cycle) {
        this.cycle = cycle;
    }

    @Override
    public long getStartedAtNanos() {
        return this.startedAtNanos;
    }

    @Override
    public D getData() {
        return this.data;
    }

    @Override
    public void setData(D data) {
        this.data = data;
    }

    @Override
    public int getTries() {
        return this.tries;
    }

    @Override
    public long getCurrentServiceTimeNanos() {
        return System.nanoTime() - this.startedAtNanos;
    }

    @Override
    public long getCurrentResponseTimeNanos() {
        return this.waitTime + this.getCurrentServiceTimeNanos();
    }

    @Override
    public long getServiceTimeNanos() {
        return this.endedAtNanos - this.startedAtNanos;
    }

    @Override
    public long getResponseTimeNanos() {
        return this.waitTime + this.getServiceTimeNanos();
    }

    @Override
    public int getResult() {
        return this.cycleResult;
    }

    public String toString() {
        return "Op{cycle=" + this.cycle + ", result=" + this.cycleResult + ", wait=" + this.waitTime + ", started=" + this.startedAtNanos + ", ended=" + this.endedAtNanos + ", tries=" + this.tries + ", data=" + (this.data == null ? "NULL" : this.data.toString()) + "}";
    }

    @Override
    public int getSkippedReason() {
        return this.skipreason;
    }
}

