/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cyclelog.buffers.results;

import io.engineblock.activityapi.cyclelog.buffers.results.CycleResult;
import io.engineblock.activityapi.cyclelog.buffers.results.CycleResultArray;
import io.engineblock.activityapi.cyclelog.buffers.results.ResultReadable;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;

public interface CycleResultsSegment
extends Comparable<CycleResultsSegment>,
Iterable<CycleResult> {
    public static final CycleResultsSegment EMPTY = new EmptySegment();

    public long getCount();

    public long getMinCycle();

    default public CycleResultsSegment filter(Predicate<ResultReadable> filter) {
        CycleResult[] filteredResults = (CycleResult[])StreamSupport.stream(this.spliterator(), false).filter(filter).toArray(CycleResult[]::new);
        return new CycleResultArray(filteredResults);
    }

    @Override
    default public int compareTo(CycleResultsSegment other) {
        return Long.compare(this.getMinCycle(), other.getMinCycle());
    }

    public static class EmptySegment
    implements CycleResultsSegment {
        @Override
        public long getCount() {
            return 0L;
        }

        @Override
        public long getMinCycle() {
            return Long.MAX_VALUE;
        }

        @Override
        public Iterator<CycleResult> iterator() {
            return Collections.emptyIterator();
        }
    }
}

