/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cyclelog.filters.tristate;

import io.engineblock.activityapi.cyclelog.buffers.results.ResultReadable;
import io.engineblock.activityapi.cyclelog.filters.tristate.CycleResultPredicate;
import io.engineblock.activityapi.cyclelog.filters.tristate.ResultFilterPhase;
import io.engineblock.activityapi.cyclelog.filters.tristate.TristateFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class ResultFilteringSieve
implements TristateFilter<ResultReadable> {
    private TristateFilter.Policy defaultPolicy;
    private List<TristateFilter<ResultReadable>> phases;

    private ResultFilteringSieve(TristateFilter.Policy defaultPolicy, List<TristateFilter<ResultReadable>> phases) {
        this.defaultPolicy = defaultPolicy;
        this.phases = phases;
    }

    @Override
    public TristateFilter.Policy apply(ResultReadable resultReadable) {
        TristateFilter.Policy policy;
        for (TristateFilter<ResultReadable> phase : this.phases) {
            policy = phase.apply(resultReadable);
            if (policy == TristateFilter.Policy.Ignore) continue;
            return policy;
        }
        policy = this.defaultPolicy;
        return policy;
    }

    public Predicate<ResultReadable> toExclusivePredicate() {
        return new ExclusiveFilterPredicate(this);
    }

    @Override
    public Predicate<ResultReadable> toDefaultingPredicate(TristateFilter.Policy defaultPolicy) {
        if (defaultPolicy == TristateFilter.Policy.Discard) {
            return this.toExclusivePredicate();
        }
        return this.toInclusivePredicate();
    }

    public Predicate<ResultReadable> toInclusivePredicate() {
        return new InclusiveFilterPredicate(this);
    }

    public static class Builder {
        private List<TristateFilter<ResultReadable>> phaseFilters = new ArrayList<TristateFilter<ResultReadable>>();
        private TristateFilter.Policy defaultPolicy = TristateFilter.Policy.Ignore;

        public Builder keepByDefault() {
            this.defaultPolicy = TristateFilter.Policy.Keep;
            return this;
        }

        public Builder discardByDefault() {
            this.defaultPolicy = TristateFilter.Policy.Discard;
            return this;
        }

        public Builder withPhase(TristateFilter<ResultReadable> phaseFilter) {
            this.phaseFilters.add(phaseFilter);
            return this;
        }

        public Builder include(int value) {
            return this.withPhase(new ResultFilterPhase(new CycleResultPredicate.ResultEquals(value), TristateFilter.Policy.Keep));
        }

        public Builder exclude(int value) {
            return this.withPhase(new ResultFilterPhase(new CycleResultPredicate.ResultEquals(value), TristateFilter.Policy.Discard));
        }

        public Builder include(int start, int end) {
            return this.withPhase(new ResultFilterPhase(new CycleResultPredicate.ResultInRange(start, end), TristateFilter.Policy.Keep));
        }

        public Builder exclude(int start, int end) {
            return this.withPhase(new ResultFilterPhase(new CycleResultPredicate.ResultInRange(start, end), TristateFilter.Policy.Discard));
        }

        public ResultFilteringSieve build() {
            return new ResultFilteringSieve(this.defaultPolicy, this.phaseFilters);
        }
    }

    private static class ExclusiveFilterPredicate
    implements Predicate<ResultReadable> {
        private final ResultFilteringSieve sieve;

        public ExclusiveFilterPredicate(ResultFilteringSieve sieve) {
            this.sieve = sieve;
        }

        @Override
        public boolean test(ResultReadable cycleResult) {
            return this.sieve.apply(cycleResult) == TristateFilter.Policy.Keep;
        }
    }

    private class InclusiveFilterPredicate
    implements Predicate<ResultReadable> {
        private ResultFilteringSieve resultFilteringSieve;

        public InclusiveFilterPredicate(ResultFilteringSieve resultFilteringSieve2) {
            this.resultFilteringSieve = resultFilteringSieve2;
        }

        @Override
        public boolean test(ResultReadable cycleResult) {
            return this.resultFilteringSieve.apply(cycleResult) != TristateFilter.Policy.Discard;
        }
    }
}

