/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl.marker;

import io.engineblock.activityapi.cyclelog.buffers.CycleResultSegmentsReadable;
import io.engineblock.activityapi.cyclelog.buffers.results.CycleResultsIntervalSegment;
import io.engineblock.activityapi.cyclelog.buffers.results.CycleResultsSegment;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class ByteTrackerExtent
implements CycleResultSegmentsReadable {
    private final long min;
    private final AtomicInteger totalMarked;
    private final AtomicInteger totalServed;
    byte[] markerData;
    private int size;
    private AtomicReference<ByteTrackerExtent> nextExtent = new AtomicReference();
    private boolean filled = false;

    public ByteTrackerExtent(long min, long nextMin) {
        this.min = min;
        this.size = (int)(nextMin - min);
        this.markerData = new byte[this.size];
        this.totalMarked = new AtomicInteger(0);
        this.totalServed = new AtomicInteger(0);
    }

    public ByteTrackerExtent(long min, int[] ints) {
        this(min, min + (long)ints.length);
        for (int i = 0; i < ints.length; ++i) {
            this.markResult(min + (long)i, ints[i]);
        }
    }

    public long markResult(long cycle, int result) {
        if (cycle < this.min) {
            return cycle - this.min;
        }
        if (cycle >= this.min + (long)this.size) {
            ByteTrackerExtent next = this.nextExtent.get();
            if (next != null) {
                return next.markResult(cycle, result);
            }
            return this.min + (long)this.size - cycle;
        }
        int position = (int)(cycle - this.min);
        byte resultCode = (byte)(result & 0x7F);
        try {
            this.markerData[position] = resultCode;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = this.totalMarked.incrementAndGet();
        return this.size - i;
    }

    public CycleResultsIntervalSegment getRemainingSegment() {
        int current = this.totalServed.get();
        int next = this.totalMarked.get();
        if (next - current == 0) {
            return null;
        }
        if (this.totalServed.compareAndSet(current, next)) {
            return CycleResultsIntervalSegment.forData((long)current + this.min, this.markerData, current, next);
        }
        throw new RuntimeException("error while attempting to consume remainder of data in extent from position " + current);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(this.min).append(",").append(this.min + (long)this.size).append("): ").append(", getCount=").append(this.size).append(", marked=").append(this.totalMarked.get()).append(", served=").append(this.totalServed.get());
        sb.append(" data=");
        if (this.markerData.length < 100) {
            for (int i = 0; i < this.markerData.length; ++i) {
                sb.append(this.markerData[i]).append(",");
            }
        } else {
            byte[] front = Arrays.copyOfRange(this.markerData, 0, 50);
            for (int i = 0; i < front.length; ++i) {
                sb.append(front[i]).append(",");
            }
            sb.append(" . . ., ");
            byte[] back = Arrays.copyOfRange(this.markerData, 0, 50);
            for (int i = 0; i < back.length; ++i) {
                sb.append(back[i]).append(",");
            }
        }
        return sb.toString();
    }

    public boolean isFullyFilled() {
        return this.totalMarked.get() == this.size;
    }

    public AtomicReference<ByteTrackerExtent> getNextExtent() {
        return this.nextExtent;
    }

    byte[] getMarkerData() {
        return this.markerData;
    }

    public ByteTrackerExtent extend() {
        ByteTrackerExtent lastExtent = this;
        while (lastExtent.getNextExtent().get() != null) {
            lastExtent = lastExtent.getNextExtent().get();
        }
        ByteTrackerExtent newLastExtent = new ByteTrackerExtent(lastExtent.getMin() + (long)this.size, lastExtent.getMin() + (long)(this.size * 2));
        if (!lastExtent.getNextExtent().compareAndSet(null, newLastExtent)) {
            throw new RuntimeException("There should be no contention for extending the extents. If this occurs, thenthere is a synchronization bug somewhere in the calling code.");
        }
        return newLastExtent;
    }

    public long getMin() {
        return this.min;
    }

    public int getSize() {
        return this.size;
    }

    public int getChainSize() {
        return 1 + (this.nextExtent.get() == null ? 0 : this.nextExtent.get().getChainSize());
    }

    public String rangeSummary() {
        return "[" + this.min + "," + (this.min + (long)this.size) + ")";
    }

    @Override
    public Iterator<CycleResultsSegment> iterator() {
        return new SegmentIterator(this.min, this.markerData);
    }

    private class SegmentIterator
    implements Iterator<CycleResultsSegment> {
        private long cycle;
        private byte[] markerData;

        public SegmentIterator(long cycle, byte[] markerData) {
            this.cycle = cycle;
            this.markerData = markerData;
        }

        @Override
        public boolean hasNext() {
            return this.markerData != null;
        }

        @Override
        public CycleResultsSegment next() {
            CycleResultsIntervalSegment cycleResults = CycleResultsIntervalSegment.forData(this.cycle, this.markerData);
            this.markerData = null;
            return cycleResults;
        }
    }
}

