/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl.marker.longheap;

public class LongTreeTracker {
    long timage = 0L;
    private static long odds = 0x5555555555555555L;
    private static long eens = -6148914691236517206L;
    private static long msbb = Long.MIN_VALUE;
    private static long left = -4294967296L;

    public LongTreeTracker(long timage) {
        this.timage = timage;
    }

    public LongTreeTracker() {
    }

    public long setCompleted(long index, long image) {
        long applybt;
        long comask;
        for (long position = 63L - index; position > 0L && ((comask = (applybt = 1L << (int)position) | (applybt & eens) >> 1 | (applybt & odds) << 1) & (image |= applybt)) == comask; position >>= 1) {
        }
        return image;
    }

    public long setCompleted(long index) {
        this.timage = this.setCompleted(index, this.timage);
        return this.timage;
    }

    public boolean isCompleted(long index) {
        long l = msbb >>> (int)index;
        return (this.timage & l) == l;
    }

    public boolean isCompleted() {
        return (this.timage & 2L) > 0L;
    }

    public long getLowestCompleted() {
        int l = Long.numberOfLeadingZeros(this.timage & left);
        return l != 64 ? (long)l : -1L;
    }

    public long getHighestCompleted() {
        int l = Long.numberOfTrailingZeros(this.timage & left);
        return l != 64 ? (long)(31 - (l - 32)) : -1L;
    }

    public long getTotalCompleted() {
        return Long.bitCount(this.timage & left);
    }

    public static String toBinaryString(long bitfield) {
        Object s = Long.toBinaryString(bitfield);
        s = "0000000000000000000000000000000000000000000000000000000000000000".substring(((String)s).length()) + (String)s;
        return s;
    }

    public String toString() {
        return LongTreeTracker.diagString(this.timage);
    }

    public static String diagString(long bitfield) {
        int i;
        String s = LongTreeTracker.toBinaryString(bitfield);
        String[] n = new String[64];
        for (int i2 = 0; i2 < n.length; ++i2) {
            n[i2] = s.substring(i2, i2 + 1);
        }
        String space = "                                                                ";
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < 32; ++i) {
            sb.append(n[i]).append(" ");
        }
        sb.append("\n");
        sb.append(" ");
        for (i = 32; i < 48; ++i) {
            sb.append(n[i]).append("   ");
        }
        sb.append("\n");
        sb.append("   ");
        for (i = 48; i < 56; ++i) {
            sb.append(n[i]).append("       ");
        }
        sb.append("\n");
        sb.append("       ");
        for (i = 56; i < 60; ++i) {
            sb.append(n[i]).append("               ");
        }
        sb.append("\n");
        sb.append("               ");
        for (i = 60; i < 62; ++i) {
            sb.append(n[i]).append("                               ");
        }
        sb.append("\n");
        sb.append("                               ").append(n[62]).append("\n");
        sb.append("                               ").append(n[63]).append("\n");
        return sb.toString();
    }

    public long getImage() {
        return this.timage;
    }
}

