/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.util;

import io.engineblock.activityapi.core.Activity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ConfigTuples
implements Iterable<Section> {
    List<Section> sections;

    public ConfigTuples(String configdata) {
        this.sections = this.parseParams(configdata);
    }

    private ConfigTuples(List<Section> sections) {
        this.sections = sections;
    }

    public ConfigTuples(Activity activity, String param) {
        this(activity.getParams().getOptionalString(param).orElse(""));
    }

    private List<Section> parseParams(String configdata) {
        try {
            List<Section> sections = Arrays.stream(configdata.split("[,]")).filter(Objects::nonNull).filter(s -> !s.isEmpty()).map(s -> new Section((String)s, "[:=]")).collect(Collectors.toList());
            return sections;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse params: '" + configdata + "': " + e);
        }
    }

    public Optional<String> getStringOfFirst(String name) {
        return this.sections.stream().filter(s -> s.isNamed(name)).findFirst().map(s -> s.get(1));
    }

    public Optional<Integer> getIntOfFirst(String name) {
        return this.getStringOfFirst(name).map(Integer::valueOf);
    }

    public Optional<Long> getLongOfFirst(String name) {
        return this.getStringOfFirst(name).map(Long::valueOf);
    }

    public Optional<Double> getDoubleOfFirst(String name) {
        return this.getStringOfFirst(name).map(Double::valueOf);
    }

    public ConfigTuples getAllMatching(String ... names) {
        List patterns = Arrays.asList(names).stream().map(Pattern::compile).collect(Collectors.toList());
        List<Section> matching = this.sections.stream().filter(s -> patterns.stream().anyMatch(p -> s.get(0).matches(p.pattern()))).collect(Collectors.toList());
        return new ConfigTuples(matching);
    }

    @Override
    public Iterator<Section> iterator() {
        return this.sections.iterator();
    }

    public Section get(int i) {
        return this.sections.get(i);
    }

    public static class Section {
        public final String[] data;

        public Section(String data, String delim) {
            this.data = data.split(delim);
        }

        public boolean isNamed(String name) {
            return this.data.length > 0 && this.data[0].equals(name);
        }

        public String get(int i) {
            return this.data[i];
        }

        public String toString() {
            return Arrays.toString(this.data);
        }
    }
}

