/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.core;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import io.engineblock.script.Scenario;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class ScenarioLogger {
    private final Scenario scenario;
    private File loggerDir = new File("logs");
    private int maxLogfiles = 10;
    private static Comparator<File> fileTimeComparator = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return Long.compare(o1.lastModified(), o2.lastModified());
        }
    };

    public ScenarioLogger(Scenario scenario) {
        this.scenario = scenario;
    }

    public ScenarioLogger setLogDir(String logDir) {
        this.loggerDir = new File(logDir);
        return this;
    }

    public ScenarioLogger setMaxLogs(int maxLogfiles) {
        this.maxLogfiles = maxLogfiles;
        return this;
    }

    public ScenarioLogger start() {
        if (!this.loggerDir.exists() && !this.loggerDir.mkdirs()) {
            throw new RuntimeException("Unable to create logger directory:" + this.loggerDir.getPath());
        }
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ConsoleAppender ca = new ConsoleAppender();
        ca.setContext((Context)loggerContext);
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        ple.setPattern("%date %level [%thread] %logger{10} [%file:%line] %msg%n");
        ple.setContext((Context)loggerContext);
        ple.start();
        String scenarioLog = this.loggerDir.getPath() + File.separator + this.scenario.getName() + ".log";
        scenarioLog = scenarioLog.replaceAll("\\s", "_");
        FileAppender fileAppender = new FileAppender();
        fileAppender.setFile(scenarioLog);
        fileAppender.setEncoder((Encoder)ple);
        fileAppender.setContext((Context)loggerContext);
        System.err.println("Logging to " + scenarioLog);
        fileAppender.start();
        Logger logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        logger.addAppender((Appender)fileAppender);
        logger.setLevel(Level.INFO);
        logger.setAdditive(true);
        this.purgeOldFiles(logger);
        return this;
    }

    private void purgeOldFiles(Logger logger) {
        if (this.maxLogfiles == 0) {
            return;
        }
        File[] files = this.loggerDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getPath().endsWith(".log");
            }
        });
        if (files == null) {
            return;
        }
        List<File> filesList = Arrays.asList(files);
        int remove = filesList.size() - this.maxLogfiles;
        if (remove <= 0) {
            return;
        }
        List toDelete = filesList.stream().sorted(fileTimeComparator).limit(remove).collect(Collectors.toList());
        for (File file : toDelete) {
            logger.info("removing extra logfile: " + file.getPath());
            if (file.delete()) continue;
            logger.warn("unable to delete: " + file);
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

