/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.core;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import io.engineblock.metrics.ActivityMetrics;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioResult {
    private static final Logger logger = LoggerFactory.getLogger(ScenarioResult.class);
    private Exception exception;
    private String iolog;
    private String report;

    public ScenarioResult(String iolog) {
        this.iolog = iolog;
    }

    public ScenarioResult(Exception e) {
        this.iolog = e.getMessage();
        this.exception = e;
    }

    public void reportToLog() {
        logger.info("-- BEGIN METRICS DETAIL --");
        Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)ActivityMetrics.getMetricRegistry()).convertDurationsTo(TimeUnit.MICROSECONDS).convertRatesTo(TimeUnit.SECONDS).filter(MetricFilter.ALL).outputTo(logger).build();
        reporter.report();
        logger.info("-- END METRICS DETAIL --");
    }

    public Optional<Exception> getException() {
        return Optional.ofNullable(this.exception);
    }

    public String getIOLog() {
        return this.iolog;
    }
}

