/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.Timer;
import io.engineblock.script.ReadOnlyBindings;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricRegistryBindings
extends ReadOnlyBindings
implements MetricRegistryListener {
    private static final Logger logger = LoggerFactory.getLogger(MetricRegistryBindings.class);
    private final MetricRegistry registry;
    private MetricMap metricMap = new MetricMap("ROOT");
    private boolean failfast = true;

    public MetricRegistryBindings(MetricRegistry registry) {
        this.registry = registry;
        registry.addListener((MetricRegistryListener)this);
    }

    @Override
    public int size() {
        return this.metricMap.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.metricMap.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.metricMap.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.metricMap.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        Object o = this.metricMap.map.get(key);
        if (o == null) {
            logger.info("fishing for a metric with '" + key + "'? we have:" + this.keySet());
        }
        return o;
    }

    @Override
    public Set<String> keySet() {
        return this.metricMap.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.metricMap.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.metricMap.map.entrySet();
    }

    public void onGaugeAdded(String name, Gauge<?> metric) {
        MetricMap parent = this.findParentNodeOf(name);
        parent.map.put(this.nodeNameOf(name), metric);
    }

    private String nodeNameOf(String name) {
        String[] split = name.split("\\.");
        return split[split.length - 1];
    }

    private synchronized void cleanEmptyMaps(MetricMap m) {
        while (m.isEmpty() && m.parent != null) {
            logger.debug("removing empty map:" + m.name);
            MetricMap parent = m.parent;
            m.parent = null;
            parent.map.remove(m.name);
            m = parent;
        }
    }

    private synchronized MetricMap findParentNodeOf(String fullName) {
        String[] names = fullName.split("\\.");
        MetricMap m = this.metricMap;
        for (int i = 0; i < names.length - 1; ++i) {
            String edge = names[i];
            if (m.map.containsKey(edge)) {
                Object o = m.map.get(edge);
                if (o instanceof MetricMap) {
                    m = (MetricMap)m.map.get(edge);
                    logger.trace("traversing edge:" + edge + " while pathing to " + fullName);
                    continue;
                }
                String error = "edge exists at level:" + i + ", while pathing to " + fullName;
                logger.error(error);
                if (!this.failfast) continue;
                throw new RuntimeException(error);
            }
            MetricMap newMap = new MetricMap(edge, m);
            m.map.put(edge, newMap);
            m = newMap;
            logger.debug("adding edge:" + edge + " while pathing to " + fullName);
        }
        return m;
    }

    public void onGaugeRemoved(String name) {
        MetricMap parent = this.findParentNodeOf(name);
        parent.map.remove(this.nodeNameOf(name));
        this.cleanEmptyMaps(parent);
    }

    public void onCounterAdded(String name, Counter metric) {
        MetricMap parent = this.findParentNodeOf(name);
        parent.map.put(this.nodeNameOf(name), metric);
    }

    public void onCounterRemoved(String name) {
        MetricMap parent = this.findParentNodeOf(name);
        parent.map.remove(this.nodeNameOf(name));
        this.cleanEmptyMaps(parent);
    }

    public void onHistogramAdded(String name, Histogram metric) {
        MetricMap parent = this.findParentNodeOf(name);
        parent.map.put(this.nodeNameOf(name), metric);
    }

    public void onHistogramRemoved(String name) {
        MetricMap parent = this.findParentNodeOf(name);
        parent.map.remove(this.nodeNameOf(name));
        this.cleanEmptyMaps(parent);
    }

    public void onMeterAdded(String name, Meter metric) {
        MetricMap parent = this.findParentNodeOf(name);
        parent.map.put(this.nodeNameOf(name), metric);
    }

    public void onMeterRemoved(String name) {
        MetricMap parent = this.findParentNodeOf(name);
        parent.map.remove(this.nodeNameOf(name));
        this.cleanEmptyMaps(parent);
    }

    public void onTimerAdded(String name, Timer metric) {
        MetricMap parent = this.findParentNodeOf(name);
        parent.map.put(this.nodeNameOf(name), metric);
    }

    public void onTimerRemoved(String name) {
        MetricMap parent = this.findParentNodeOf(name);
        parent.map.remove(this.nodeNameOf(name));
        this.cleanEmptyMaps(parent);
    }

    public Map<String, Metric> getMetrics() {
        return this.getMetrics(new LinkedHashMap<String, Metric>(), "metrics", this.metricMap);
    }

    private Map<String, Metric> getMetrics(Map<String, Metric> totalMap, String prefix, MetricMap map) {
        for (Map.Entry<String, Object> mEntry : map.entrySet()) {
            Object o = mEntry.getValue();
            String name = prefix + "." + mEntry.getKey();
            if (o instanceof Metric) {
                totalMap.put(name, (Metric)o);
                continue;
            }
            if (o instanceof MetricMap) {
                this.getMetrics(totalMap, name, (MetricMap)o);
                continue;
            }
            throw new RuntimeException("entry value must be either a Metric or a MetricMap");
        }
        return totalMap;
    }

    private class MetricMap
    extends ReadOnlyBindings {
        Map<String, Object> map = new HashMap<String, Object>();
        MetricMap parent = null;
        public String name;

        MetricMap(String name) {
            this.name = name;
        }

        public MetricMap(String name, MetricMap parent) {
            this.parent = parent;
            this.name = name;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public Object get(Object key) {
            return this.map.get(key);
        }

        @Override
        public Set<String> keySet() {
            return this.map.keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.map.entrySet();
        }
    }
}

