/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.script;

import com.codahale.metrics.MetricRegistry;
import io.engineblock.activitycore.ProgressIndicator;
import io.engineblock.core.ScenarioController;
import io.engineblock.core.ScenarioLogger;
import io.engineblock.core.ScenarioResult;
import io.engineblock.core.UserException;
import io.engineblock.extensions.ScriptingPluginInfo;
import io.engineblock.metrics.ActivityMetrics;
import io.engineblock.metrics.MetricRegistryBindings;
import io.engineblock.script.ActivityBindings;
import io.engineblock.script.SandboxExtensionFinder;
import io.engineblock.script.ScenarioContext;
import io.engineblock.script.ScriptParams;
import io.engineblock.scripting.ScriptEnvBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scenario
implements Callable<ScenarioResult> {
    private static final ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger(Scenario.class);
    private static final ScriptEngineManager engineManager = new ScriptEngineManager();
    private final List<String> scripts = new ArrayList<String>();
    private ScriptEngine scriptEngine;
    private ScenarioController scenarioController;
    private ProgressIndicator progressIndicator;
    private String progressInterval = "console:1m";
    private ScenarioContext scriptEnv;
    private String name;
    private ScenarioLogger scenarioLogger;
    private ScriptParams scenarioScriptParams;
    private boolean areChartsEnabled;

    public Scenario(String name, String progressInterval) {
        this.name = name;
        this.progressInterval = progressInterval;
    }

    public Scenario(String name) {
        this.name = name;
    }

    public Scenario addScriptText(String scriptText) {
        this.scripts.add(scriptText);
        return this;
    }

    public Scenario addScriptFiles(String ... args) {
        for (String scriptFile : args) {
            Path scriptPath = Paths.get(scriptFile, new String[0]);
            byte[] bytes = new byte[]{};
            try {
                bytes = Files.readAllBytes(scriptPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            Charset utf8 = Charset.forName("UTF8");
            String scriptData = utf8.decode(bb).toString();
            this.addScriptText(scriptData);
        }
        return this;
    }

    private void init() {
        MetricRegistry metricRegistry = ActivityMetrics.getMetricRegistry();
        this.scriptEngine = engineManager.getEngineByName("nashorn");
        this.scriptEnv = new ScenarioContext(this.scenarioController);
        this.scriptEngine.setContext((ScriptContext)((Object)this.scriptEnv));
        this.scenarioController = new ScenarioController();
        if (!this.progressInterval.equals("disabled")) {
            this.progressIndicator = new ProgressIndicator(this.scenarioController, this.progressInterval);
        }
        this.scriptEngine.put("params", this.scenarioScriptParams);
        this.scriptEngine.put("scenario", this.scenarioController);
        this.scriptEngine.put("activities", new ActivityBindings(this.scenarioController));
        this.scriptEngine.put("metrics", new MetricRegistryBindings(metricRegistry));
        for (ScriptingPluginInfo<?> extensionDescriptor : SandboxExtensionFinder.findAll()) {
            if (!extensionDescriptor.isAutoLoading()) {
                logger.info("Not loading " + extensionDescriptor + ", autoloading is false");
                continue;
            }
            Logger extensionLogger = LoggerFactory.getLogger((String)("extensions." + extensionDescriptor.getBaseVariableName()));
            Object extensionObject = extensionDescriptor.getExtensionObject(extensionLogger, metricRegistry, (ScriptContext)((Object)this.scriptEnv));
            logger.debug("Adding extension object:  name=" + extensionDescriptor.getBaseVariableName() + " class=" + extensionObject.getClass().getSimpleName());
            this.scriptEngine.put(extensionDescriptor.getBaseVariableName(), extensionObject);
        }
    }

    public void run() {
        this.init();
        logger.info("Running control script for " + this.getName() + ".");
        for (String script : this.scripts) {
            try {
                Object result = null;
                if (this.scriptEngine instanceof Compilable) {
                    logger.info("Using direct script compilation");
                    Compilable compilableEngine = (Compilable)((Object)this.scriptEngine);
                    CompiledScript compiled = compilableEngine.compile(script);
                    result = compiled.eval();
                } else {
                    result = this.scriptEngine.eval(script);
                }
                System.err.flush();
                System.out.flush();
            }
            catch (ScriptException e) {
                String diagname = "diag_" + System.currentTimeMillis() + ".js";
                try {
                    Path diagFilePath = Paths.get(this.scenarioLogger.getLogDir(), diagname);
                    Files.write(diagFilePath, script.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (Exception diagFilePath) {
                    // empty catch block
                }
                String errorDesc = "Script error while running scenario:" + e.toString() + ", script content is at " + diagname;
                e.printStackTrace();
                logger.error(errorDesc, (Throwable)e);
                this.scenarioController.forceStopScenario(5000);
                throw new RuntimeException("Script error while running scenario:" + e.getMessage(), e);
            }
            catch (UserException ue) {
                logger.error(ue.getMessage());
                this.scenarioController.forceStopScenario(5000);
                throw ue;
            }
            catch (Exception o) {
                String errorDesc = "Non-Script error while running scenario:" + o.getMessage();
                logger.error(errorDesc, (Throwable)o);
                this.scenarioController.forceStopScenario(5000);
                throw new RuntimeException("Non-Script error while running scenario:" + o.getMessage(), o);
            }
        }
        int awaitCompletionTime = 1471228928;
        logger.info("Awaiting completion of scenario for " + awaitCompletionTime + " millis.");
        this.scenarioController.awaitCompletion(awaitCompletionTime);
    }

    @Override
    public ScenarioResult call() {
        this.run();
        String iolog = this.scriptEnv.getTimedLog();
        return new ScenarioResult(iolog);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scenario scenario = (Scenario)o;
        return this.getName() != null ? this.getName().equals(scenario.getName()) : scenario.getName() == null;
    }

    public int hashCode() {
        return this.getName() != null ? this.getName().hashCode() : 0;
    }

    public String getName() {
        return this.name;
    }

    public ScenarioController getScenarioController() {
        return this.scenarioController;
    }

    public String getScriptText() {
        return this.scripts.stream().collect(Collectors.joining());
    }

    public Optional<List<String>> getIOLog() {
        return Optional.ofNullable(this.scriptEnv).map(ScriptEnvBuffer::getTimeLogLines);
    }

    public String toString() {
        return "name:'" + this.getName() + "'";
    }

    public void setScenarioLogger(ScenarioLogger scenarioLogger) {
        this.scenarioLogger = scenarioLogger;
    }

    public void addScenarioScriptParams(ScriptParams scenarioScriptParams) {
        this.scenarioScriptParams = scenarioScriptParams;
    }

    public void addScenarioScriptParams(final Map<String, String> scriptParams) {
        this.addScenarioScriptParams(new ScriptParams(){
            {
                this.putAll(scriptParams);
            }
        });
    }

    public void enableCharting() {
        MetricRegistry metricRegistry = ActivityMetrics.getMetricRegistry();
    }
}

