package io.fabric8.kubernetes.client.extended.run;

import java.lang.StringBuilder;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class RunConfigFluentImpl<A extends RunConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RunConfigFluent<A> {

    private String name;
    private String image;
    private String imagePullPolicy;
    private String command;
    private List<String> args;
    private String restartPolicy;
    private String serviceAccount;
    private Map<String,String> labels;
    private Map<String,String> env;
    private Map<String,Quantity> limits;
    private Map<String,Quantity> requests;
    private int port;

    public RunConfigFluentImpl() {
    }

    public RunConfigFluentImpl(RunConfig instance) {
        this.withName(instance.getName()); 
        this.withImage(instance.getImage()); 
        this.withImagePullPolicy(instance.getImagePullPolicy()); 
        this.withCommand(instance.getCommand()); 
        this.withArgs(instance.getArgs()); 
        this.withRestartPolicy(instance.getRestartPolicy()); 
        this.withServiceAccount(instance.getServiceAccount()); 
        this.withLabels(instance.getLabels()); 
        this.withEnv(instance.getEnv()); 
        this.withLimits(instance.getLimits()); 
        this.withRequests(instance.getRequests()); 
        this.withPort(instance.getPort()); 
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image=image; return (A) this;
    }

    public Boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(StringBuilder arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(int[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(char[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(byte[] arg1,int arg2) {
        return (A)withImage(new String(arg1, arg2));
    }

    public A withNewImage(byte[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(char[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewImage(String arg1) {
        return (A)withImage(new String(arg1));
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public A withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy=imagePullPolicy; return (A) this;
    }

    public Boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    public A withNewImagePullPolicy(StringBuilder arg1) {
        return (A)withImagePullPolicy(new String(arg1));
    }

    public A withNewImagePullPolicy(int[] arg1,int arg2,int arg3) {
        return (A)withImagePullPolicy(new String(arg1, arg2, arg3));
    }

    public A withNewImagePullPolicy(char[] arg1) {
        return (A)withImagePullPolicy(new String(arg1));
    }

    public A withNewImagePullPolicy(StringBuffer arg1) {
        return (A)withImagePullPolicy(new String(arg1));
    }

    public A withNewImagePullPolicy(byte[] arg1,int arg2) {
        return (A)withImagePullPolicy(new String(arg1, arg2));
    }

    public A withNewImagePullPolicy(byte[] arg1) {
        return (A)withImagePullPolicy(new String(arg1));
    }

    public A withNewImagePullPolicy(char[] arg1,int arg2,int arg3) {
        return (A)withImagePullPolicy(new String(arg1, arg2, arg3));
    }

    public A withNewImagePullPolicy(byte[] arg1,int arg2,int arg3) {
        return (A)withImagePullPolicy(new String(arg1, arg2, arg3));
    }

    public A withNewImagePullPolicy(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withImagePullPolicy(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewImagePullPolicy(String arg1) {
        return (A)withImagePullPolicy(new String(arg1));
    }

    public String getCommand() {
        return this.command;
    }

    public A withCommand(String command) {
        this.command=command; return (A) this;
    }

    public Boolean hasCommand() {
        return this.command != null;
    }

    public A withNewCommand(StringBuilder arg1) {
        return (A)withCommand(new String(arg1));
    }

    public A withNewCommand(int[] arg1,int arg2,int arg3) {
        return (A)withCommand(new String(arg1, arg2, arg3));
    }

    public A withNewCommand(char[] arg1) {
        return (A)withCommand(new String(arg1));
    }

    public A withNewCommand(StringBuffer arg1) {
        return (A)withCommand(new String(arg1));
    }

    public A withNewCommand(byte[] arg1,int arg2) {
        return (A)withCommand(new String(arg1, arg2));
    }

    public A withNewCommand(byte[] arg1) {
        return (A)withCommand(new String(arg1));
    }

    public A withNewCommand(char[] arg1,int arg2,int arg3) {
        return (A)withCommand(new String(arg1, arg2, arg3));
    }

    public A withNewCommand(byte[] arg1,int arg2,int arg3) {
        return (A)withCommand(new String(arg1, arg2, arg3));
    }

    public A withNewCommand(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withCommand(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewCommand(String arg1) {
        return (A)withCommand(new String(arg1));
    }

    public A addToArgs(int index,String item) {
        if (this.args == null) {this.args = new ArrayList<String>();}
        this.args.add(index, item);
        return (A)this;
    }

    public A setToArgs(int index,String item) {
        if (this.args == null) {this.args = new ArrayList<String>();}
        this.args.set(index, item); return (A)this;
    }

    public A addToArgs(String... items) {
        if (this.args == null) {this.args = new ArrayList<String>();}
        for (String item : items) {this.args.add(item);} return (A)this;
    }

    public A addAllToArgs(Collection<String> items) {
        if (this.args == null) {this.args = new ArrayList<String>();}
        for (String item : items) {this.args.add(item);} return (A)this;
    }

    public A removeFromArgs(String... items) {
        for (String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
    }

    public A removeAllFromArgs(Collection<String> items) {
        for (String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public String getArg(int index) {
        return this.args.get(index);
    }

    public String getFirstArg() {
        return this.args.get(0);
    }

    public String getLastArg() {
        return this.args.get(args.size() - 1);
    }

    public String getMatchingArg(Predicate<String> predicate) {
        for (String item: args) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingArg(Predicate<String> predicate) {
        for (String item: args) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withArgs(List<String> args) {
        if (this.args != null) { _visitables.get("args").removeAll(this.args);}
        if (args != null) {this.args = new ArrayList<String>(); for (String item : args){this.addToArgs(item);}} else { this.args = null;} return (A) this;
    }

    public A withArgs(String... args) {
        if (this.args != null) {this.args.clear();}
        if (args != null) {for (String item :args){ this.addToArgs(item);}} return (A) this;
    }

    public Boolean hasArgs() {
        return args != null && !args.isEmpty();
    }

    public A addNewArg(StringBuilder arg1) {
        return (A)addToArgs(new String(arg1));
    }

    public A addNewArg(int[] arg1,int arg2,int arg3) {
        return (A)addToArgs(new String(arg1, arg2, arg3));
    }

    public A addNewArg(char[] arg1) {
        return (A)addToArgs(new String(arg1));
    }

    public A addNewArg(StringBuffer arg1) {
        return (A)addToArgs(new String(arg1));
    }

    public A addNewArg(byte[] arg1,int arg2) {
        return (A)addToArgs(new String(arg1, arg2));
    }

    public A addNewArg(byte[] arg1) {
        return (A)addToArgs(new String(arg1));
    }

    public A addNewArg(char[] arg1,int arg2,int arg3) {
        return (A)addToArgs(new String(arg1, arg2, arg3));
    }

    public A addNewArg(byte[] arg1,int arg2,int arg3) {
        return (A)addToArgs(new String(arg1, arg2, arg3));
    }

    public A addNewArg(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToArgs(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewArg(String arg1) {
        return (A)addToArgs(new String(arg1));
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy=restartPolicy; return (A) this;
    }

    public Boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    public A withNewRestartPolicy(StringBuilder arg1) {
        return (A)withRestartPolicy(new String(arg1));
    }

    public A withNewRestartPolicy(int[] arg1,int arg2,int arg3) {
        return (A)withRestartPolicy(new String(arg1, arg2, arg3));
    }

    public A withNewRestartPolicy(char[] arg1) {
        return (A)withRestartPolicy(new String(arg1));
    }

    public A withNewRestartPolicy(StringBuffer arg1) {
        return (A)withRestartPolicy(new String(arg1));
    }

    public A withNewRestartPolicy(byte[] arg1,int arg2) {
        return (A)withRestartPolicy(new String(arg1, arg2));
    }

    public A withNewRestartPolicy(byte[] arg1) {
        return (A)withRestartPolicy(new String(arg1));
    }

    public A withNewRestartPolicy(char[] arg1,int arg2,int arg3) {
        return (A)withRestartPolicy(new String(arg1, arg2, arg3));
    }

    public A withNewRestartPolicy(byte[] arg1,int arg2,int arg3) {
        return (A)withRestartPolicy(new String(arg1, arg2, arg3));
    }

    public A withNewRestartPolicy(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withRestartPolicy(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewRestartPolicy(String arg1) {
        return (A)withRestartPolicy(new String(arg1));
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount=serviceAccount; return (A) this;
    }

    public Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public A withNewServiceAccount(StringBuilder arg1) {
        return (A)withServiceAccount(new String(arg1));
    }

    public A withNewServiceAccount(int[] arg1,int arg2,int arg3) {
        return (A)withServiceAccount(new String(arg1, arg2, arg3));
    }

    public A withNewServiceAccount(char[] arg1) {
        return (A)withServiceAccount(new String(arg1));
    }

    public A withNewServiceAccount(StringBuffer arg1) {
        return (A)withServiceAccount(new String(arg1));
    }

    public A withNewServiceAccount(byte[] arg1,int arg2) {
        return (A)withServiceAccount(new String(arg1, arg2));
    }

    public A withNewServiceAccount(byte[] arg1) {
        return (A)withServiceAccount(new String(arg1));
    }

    public A withNewServiceAccount(char[] arg1,int arg2,int arg3) {
        return (A)withServiceAccount(new String(arg1, arg2, arg3));
    }

    public A withNewServiceAccount(byte[] arg1,int arg2,int arg3) {
        return (A)withServiceAccount(new String(arg1, arg2, arg3));
    }

    public A withNewServiceAccount(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withServiceAccount(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewServiceAccount(String arg1) {
        return (A)withServiceAccount(new String(arg1));
    }

    public A addToLabels(String key,String value) {
        if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
    }

    public A addToLabels(Map<String,String> map) {
        if(this.labels == null && map != null) { this.labels = new LinkedHashMap<String,String>(); }
        if(map != null) { this.labels.putAll(map);} return (A)this;
    }

    public A removeFromLabels(String key) {
        if(this.labels == null) { return (A) this; }
        if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
    }

    public A removeFromLabels(Map<String,String> map) {
        if(this.labels == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
    }

    public Map<String,String> getLabels() {
        return this.labels;
    }

    public <K extends Object,V extends Object>A withLabels(Map<String,String> labels) {
        if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap<String,String>(labels);} return (A) this;
    }

    public Boolean hasLabels() {
        return this.labels != null;
    }

    public A addToEnv(String key,String value) {
        if(this.env == null && key != null && value != null) { this.env = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.env.put(key, value);} return (A)this;
    }

    public A addToEnv(Map<String,String> map) {
        if(this.env == null && map != null) { this.env = new LinkedHashMap<String,String>(); }
        if(map != null) { this.env.putAll(map);} return (A)this;
    }

    public A removeFromEnv(String key) {
        if(this.env == null) { return (A) this; }
        if(key != null && this.env != null) {this.env.remove(key);} return (A)this;
    }

    public A removeFromEnv(Map<String,String> map) {
        if(this.env == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.env != null){this.env.remove(key);}}} return (A)this;
    }

    public Map<String,String> getEnv() {
        return this.env;
    }

    public <K extends Object,V extends Object>A withEnv(Map<String,String> env) {
        if (env == null) { this.env =  null;} else {this.env = new LinkedHashMap<String,String>(env);} return (A) this;
    }

    public Boolean hasEnv() {
        return this.env != null;
    }

    public A addToLimits(String key,Quantity value) {
        if(this.limits == null && key != null && value != null) { this.limits = new LinkedHashMap<String,Quantity>(); }
        if(key != null && value != null) {this.limits.put(key, value);} return (A)this;
    }

    public A addToLimits(Map<String,Quantity> map) {
        if(this.limits == null && map != null) { this.limits = new LinkedHashMap<String,Quantity>(); }
        if(map != null) { this.limits.putAll(map);} return (A)this;
    }

    public A removeFromLimits(String key) {
        if(this.limits == null) { return (A) this; }
        if(key != null && this.limits != null) {this.limits.remove(key);} return (A)this;
    }

    public A removeFromLimits(Map<String,Quantity> map) {
        if(this.limits == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.limits != null){this.limits.remove(key);}}} return (A)this;
    }

    public Map<String,Quantity> getLimits() {
        return this.limits;
    }

    public <K extends Object,V extends Object>A withLimits(Map<String,Quantity> limits) {
        if (limits == null) { this.limits =  null;} else {this.limits = new LinkedHashMap<String,Quantity>(limits);} return (A) this;
    }

    public Boolean hasLimits() {
        return this.limits != null;
    }

    public A addToRequests(String key,Quantity value) {
        if(this.requests == null && key != null && value != null) { this.requests = new LinkedHashMap<String,Quantity>(); }
        if(key != null && value != null) {this.requests.put(key, value);} return (A)this;
    }

    public A addToRequests(Map<String,Quantity> map) {
        if(this.requests == null && map != null) { this.requests = new LinkedHashMap<String,Quantity>(); }
        if(map != null) { this.requests.putAll(map);} return (A)this;
    }

    public A removeFromRequests(String key) {
        if(this.requests == null) { return (A) this; }
        if(key != null && this.requests != null) {this.requests.remove(key);} return (A)this;
    }

    public A removeFromRequests(Map<String,Quantity> map) {
        if(this.requests == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.requests != null){this.requests.remove(key);}}} return (A)this;
    }

    public Map<String,Quantity> getRequests() {
        return this.requests;
    }

    public <K extends Object,V extends Object>A withRequests(Map<String,Quantity> requests) {
        if (requests == null) { this.requests =  null;} else {this.requests = new LinkedHashMap<String,Quantity>(requests);} return (A) this;
    }

    public Boolean hasRequests() {
        return this.requests != null;
    }

    public int getPort() {
        return this.port;
    }

    public A withPort(int port) {
        this.port=port; return (A) this;
    }

    public Boolean hasPort() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RunConfigFluentImpl that = (RunConfigFluentImpl) o;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (imagePullPolicy != null ? !imagePullPolicy.equals(that.imagePullPolicy) :that.imagePullPolicy != null) return false;
        if (command != null ? !command.equals(that.command) :that.command != null) return false;
        if (args != null ? !args.equals(that.args) :that.args != null) return false;
        if (restartPolicy != null ? !restartPolicy.equals(that.restartPolicy) :that.restartPolicy != null) return false;
        if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
        if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
        if (env != null ? !env.equals(that.env) :that.env != null) return false;
        if (limits != null ? !limits.equals(that.limits) :that.limits != null) return false;
        if (requests != null ? !requests.equals(that.requests) :that.requests != null) return false;
        if (port != that.port) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(name,  image,  imagePullPolicy,  command,  args,  restartPolicy,  serviceAccount,  labels,  env,  limits,  requests,  port,  super.hashCode());
    }

}
