
                                          

package io.fabric8.kubernetes.client.handlers.core.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.PersistentVolumeOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class PersistentVolumeHandler implements ResourceHandler<PersistentVolume, PersistentVolumeBuilder> {

  @Override
  public String getKind() {
    return PersistentVolume.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "v1";
      }

  @Override
  public PersistentVolume create(OkHttpClient client, Config config, String namespace, PersistentVolume item, boolean dryRun) {
    return new PersistentVolumeOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public PersistentVolume replace(OkHttpClient client, Config config, String namespace, PersistentVolume item, boolean dryRun) {
    return new PersistentVolumeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public PersistentVolume reload(OkHttpClient client, Config config, String namespace, PersistentVolume item) {
    return new PersistentVolumeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public PersistentVolumeBuilder edit(PersistentVolume item) {
    return new PersistentVolumeBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, PersistentVolume item, boolean dryRun) {
    return new PersistentVolumeOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PersistentVolume item, Watcher<PersistentVolume> watcher) {
    return new PersistentVolumeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PersistentVolume item, String resourceVersion, Watcher<PersistentVolume> watcher) {
    return new PersistentVolumeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PersistentVolume item, ListOptions options, Watcher<PersistentVolume> watcher) {
    return new PersistentVolumeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public PersistentVolume waitUntilReady(OkHttpClient client, Config config, String namespace, PersistentVolume item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PersistentVolumeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public PersistentVolume waitUntilCondition(OkHttpClient client, Config config, String namespace, PersistentVolume item, Predicate<PersistentVolume> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PersistentVolumeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
